/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class LoaderMainModule
extends MainModule {
    private LoaderModule loader;
    private FilterHolder autochanger;

    public LoaderMainModule(BridgeToHardware bridge) {
        super(bridge);
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getComponentLookup();
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.autochanger = (FilterHolder)lookup.getComponentByName("autochanger");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        this.loader.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSState() {
        if (this.loader.isInitialized()) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.bridge.printHardwareState());
        sb.append("\n ");
        sb.append(this.loader.printHardwareState());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(this.loader.toString());
        return sb.toString();
    }
}

