/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;

public class LoaderHookModule
extends Module {
    private final NumericSensor lockSensor;
    private final NumericSensor unlockSensor;
    private FcsEnumerations.LockStatus lockStatus;
    protected final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    protected volatile boolean updatingState = false;

    public LoaderHookModule(NumericSensor lockSensor, NumericSensor unlockSensor) {
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ": getLockStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initModule() {
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.lockSensor.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            boolean bl = this.inError = this.locked && this.unlocked;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.locked ? FcsEnumerations.LockStatus.LOCKED : (this.unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.INTRAVEL));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="display sensors info")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("#locksensor=");
        sb.append(this.lockSensor.toString());
        sb.append("#unlocksensor=");
        sb.append(this.unlockSensor.toString());
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display hook sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/locksensor value=");
        sb.append(this.lockSensor.getDigitalValue());
        sb.append("/unlocksensor value=");
        sb.append(this.unlockSensor.getDigitalValue());
        sb.append("/lockStatus=");
        sb.append(this.lockStatus.toString());
        sb.append("/");
        return sb.toString();
    }

    StatusDataPublishedByLoaderHook createStatusDataPublishedByLoaderHook() {
        return new StatusDataPublishedByLoaderHook(this.getName(), this.lockSensor.getDigitalValue(), this.unlockSensor.getDigitalValue(), this.inError, this.lockStatus);
    }
}

