/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderHookModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.CanOpenCallTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class LoaderClampModule
extends MobileItemModule
implements MovedByEPOSController {
    private final LoaderHookModule hook1;
    private final LoaderHookModule hook2;
    private final LoaderHookModule hook3;
    private final LoaderHookModule hook4;
    private final LoaderHookModule[] hooks;
    private EPOSController hooksController;
    private LoaderModule loader;
    private BridgeToHardware bridgeToLoader;
    private FcsEnumerations.LockStatus lockStatus;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClosingHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if closing strongly the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClampingHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForOpeningHooks = 60000L;
    @ConfigurationParameter(description="timeout in milliseconds : if the action of hoing to home position last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForGoingToHomePosition = 60000L;
    @ConfigurationParameter(description="target encoder absolute value in qc to open")
    private int targetPositionToOpen = 5000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are LOCKED")
    private int targetPositionToClose = 492000;
    @ConfigurationParameter(description="target encoder absolute value in qc when hooks are LOCKED STRONGLY")
    private int targetPositionToClamp = 515000;
    @ConfigurationParameter(description="current to close in initialisation phase, in mA")
    private int currentToClamp = 280;
    @ConfigurationParameter(description="current to go to home position in initialisation phase, in mA")
    private int currentToGoHome = -200;
    @ConfigurationParameter(description="min position value used by the GUI")
    private int minPosition = 0;
    @ConfigurationParameter(description="max position value used by the GUI")
    private int maxPosition = 515000;
    @ConfigurationParameter(description="min current value used by the GUI")
    private final int minCurrent = -300;
    @ConfigurationParameter(description="max current value used by the GUI")
    private final int maxCurrent = 400;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrentToGoHome;
    @ConfigurationParameter
    private Map<String, Integer> paramsForCurrentToClamp;
    private volatile boolean initialized = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private int position;
    private int readCurrent;
    private int force;
    private boolean controllerInFault;

    public LoaderClampModule(LoaderHookModule hook1, LoaderHookModule hook2, LoaderHookModule hook3, LoaderHookModule hook4, Map<String, Integer> paramsForCurrentToClamp, Map<String, Integer> paramsForCurrentToGoHomePosition) {
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.hooks = new LoaderHookModule[]{hook1, hook2, hook3, hook4};
        this.paramsForCurrentToClamp = paramsForCurrentToClamp;
        this.paramsForCurrentToGoHome = paramsForCurrentToGoHomePosition;
    }

    @Override
    public String getControllerName() {
        return this.hooksController.getName();
    }

    @Override
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public int getTargetPositionToOpen() {
        return this.targetPositionToOpen;
    }

    public int getTargetPositionToClose() {
        return this.targetPositionToClose;
    }

    public int getTargetPositionToClamp() {
        return this.targetPositionToClamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToGoHome() {
        return this.currentToGoHome;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if loader clamp is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED")
    public boolean isLocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isUnlocked() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.UNLOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED")
    public boolean isInError() {
        return this.getLockStatus() == FcsEnumerations.LockStatus.ERROR || this.getLockStatus() == FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.bridgeToLoader.isCANDevicesReady();
    }

    @Override
    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        this.hooksController = (EPOSController)lookup.getComponentByName("hooksController");
        this.loader = (LoaderModule)lookup.getComponentByName("loader");
        this.bridgeToLoader = (BridgeToHardware)lookup.getComponentByName("loaderTcpProxy");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.hooksController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.hooksController)});
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is open and at home position")
    public boolean isAtHomePosition() {
        return this.position == 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is closed and at clamped position")
    public boolean isAtClampedPosition() {
        return this.targetPositionToClamp - 1000 <= this.position && this.targetPositionToClamp <= this.position + 1000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at closed position.")
    public boolean isAtClosedPosition() {
        return this.position == this.targetPositionToClose;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hook is at open position.")
    public boolean isAtOpenPosition() {
        return this.position == this.targetPositionToOpen;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Attention : this commands moves the clamp to do the homing of the controller. If loader is empty, go to home position otherwise go to clamped position.", alias="homing")
    public void initializeHardware() {
        this.loader.updateStateWithSensors();
        this.publishData();
        this.checkSensorsOK();
        this.hooksController.checkInitialized();
        if (this.loader.isEmpty()) {
            this.goToHomePosition();
        } else {
            this.goToClampedPosition();
        }
        this.initialized = true;
        this.loader.updateFCSState();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + ":" + (Object)((Object)ex)));
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public void checkSensorsOK() {
        if (this.isInError()) {
            String msg = this.getName() + " in ERROR state - can't execute commands.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    public void checkInitialized() {
        if (!this.isInitialized()) {
            String msg = this.getName() + ": clamp is not intialized.";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void tick() {
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to clamped position to intialize hardware.")
    public void goToClampedPosition() {
        this.loader.updateStateWithSensors();
        this.loader.checkConnectedOnCamera();
        this.checkSensorsOK();
        if (this.loader.isEmpty()) {
            throw new RejectedCommandException(this.getName() + "No filter in carrier -  can't execute command goToClampedPosition.");
        }
        this.updatePosition();
        if (this.initialized && this.isAtClampedPosition()) {
            throw new RejectedCommandException(this.getName() + " is already at clamped position - nothing to do.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Go to home position to initialize hardware.")
    public void goToHomePosition() {
        this.loader.updateStateWithSensors();
        this.loader.checkConnectedOnCamera();
        this.checkConditionsToGoToHomePosition();
        this.updatePosition();
        this.executeAction(FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION, this.timeoutForGoingToHomePosition);
    }

    public void checkConditionsToGoToHomePosition() {
        this.checkSensorsOK();
        if (!this.initialized && !this.loader.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " There is a filter in carrier - can't execute command goToHomePosition.");
        }
        if (this.initialized && !this.loader.isEmpty() && !this.loader.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " There is a filter in carrier and Autochanger is not holding filter - can't execute command goToHomePosition. ");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close clamp.")
    public void close() {
        this.loader.checkPreConditionsForClosingHooks();
        if (this.isAtClosedPosition()) {
            String msg = this.getName() + ": is already closed.";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS, this.timeoutForClosingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clamp clamp.")
    public void clamp() {
        this.loader.checkPreConditionsForClosingHooks();
        if (!this.isLocked()) {
            throw new RejectedCommandException(this.getName() + " has to be LOCKED first. Close hooks prior clamp.");
        }
        if (this.loader.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " Autochanger is holding filter. Open autochanger latches before clamping loader hooks.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS, this.timeoutForClampingHooks);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open clamp.")
    public void open() {
        this.loader.checkConditionsForOpeningHooks();
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLOADERHOOKS, this.timeoutForOpeningHooks);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        boolean actionCompleted = false;
        if (action == FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) {
            actionCompleted = this.isCurrentReached(this.currentToGoHome);
        } else if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            actionCompleted = this.position == this.targetPositionToOpen;
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            actionCompleted = this.position == this.targetPositionToClose;
        } else if (action == FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION || action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
            actionCompleted = this.isCurrentReached(this.currentToClamp);
        }
        return actionCompleted;
    }

    private boolean isCurrentReached(int currentToReach) {
        int DELTA = 5;
        FCSLOG.debug((Object)("readCurrent=" + this.readCurrent + " currentToReached=" + currentToReach));
        return currentToReach - DELTA <= this.readCurrent && this.readCurrent <= currentToReach + DELTA;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.loader.updateStateWithSensors();
            if (this.currentAction == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS || this.currentAction == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
                this.position = this.hooksController.readPosition();
            } else if (this.currentAction == FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION || this.currentAction == FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION || this.currentAction == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
                this.readCurrent = this.hooksController.readCurrent();
                this.position = this.hooksController.readPosition();
                this.force = this.readForceSensor();
            }
        }
        catch (CanOpenCallTimeoutException ex) {
            this.raiseWarning(this.getName() + ":" + FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT, FcsEnumerations.FcsAlert.CAN_BUS_TIMEOUT.getLongDescription(), (Exception)((Object)ex));
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION) {
            this.controllerWriteCurrent(this.currentToClamp, this.paramsForCurrentToClamp);
        } else if (action == FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) {
            this.controllerWriteCurrent(this.currentToGoHome, this.paramsForCurrentToGoHome);
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            this.controllerWriteAbsoluteTargetPosition(this.targetPositionToClose);
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS) {
            if (!this.lockStatus.equals((Object)FcsEnumerations.LockStatus.LOCKED)) {
                throw new RejectedCommandException(this.getName() + ": Hooks have to be LOCKED before being LOCKED STRONGLY");
            }
            this.controllerWriteCurrent(this.currentToClamp, this.paramsForCurrentToClamp);
        } else if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            this.controllerWriteAbsoluteTargetPosition(this.targetPositionToOpen);
        }
    }

    private void controllerWriteCurrent(int current, Map<String, Integer> paramsForCurrent) {
        this.hooksController.enable();
        this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.hooksController.writeParameters(paramsForCurrent);
        this.hooksController.writeCurrent(current);
    }

    private void controllerWriteAbsoluteTargetPosition(int pos) {
        this.hooksController.enable();
        this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.hooksController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.hooksController.writeTargetPosition(pos);
        this.hooksController.writeControlWord("3F");
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.hooksController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.getName() + " is STOPPING action " + action.toString() + " within delay " + delay));
        this.hooksController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.hooksController.off();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction."));
        if (action == FcsEnumerations.MobileItemAction.GOTOCLAMPEDPOSITION) {
            this.checkLOCKED();
            this.postActionGOTOCLAMPEDPOSITION();
        } else if (action == FcsEnumerations.MobileItemAction.GOTOHOMEPOSITION) {
            this.checkUNLOCKED();
            this.postActionGOTOHOMEPOSITION();
        } else if (action == FcsEnumerations.MobileItemAction.CLOSELOADERHOOKS) {
            this.checkLOCKED();
        } else if (action == FcsEnumerations.MobileItemAction.OPENLOADERHOOKS) {
            this.checkUNLOCKED();
        } else if (action == FcsEnumerations.MobileItemAction.CLAMPLOADERHOOKS && this.isLocked() && this.isAtClampedPosition()) {
            this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
            this.publishData();
        }
    }

    private void postActionGOTOCLAMPEDPOSITION() {
        this.hooksController.defineAbsolutePosition(this.targetPositionToClamp);
        this.hooksController.off();
        this.updatePosition();
        this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
        this.initialized = true;
        this.publishData();
        this.loader.updateFCSState();
    }

    private void postActionGOTOHOMEPOSITION() {
        this.hooksController.defineAbsolutePosition(0);
        this.hooksController.off();
        this.updatePosition();
        this.initialized = true;
        this.publishData();
        this.loader.updateFCSState();
    }

    private void checkLOCKED() {
        if (!this.isLocked()) {
            throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be LOCKED.");
        }
    }

    private void checkUNLOCKED() {
        if (!this.isUnlocked()) {
            throw new FailedCommandException(this.getName() + ": check with sensors: clamp should be UNLOCKED.");
        }
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.updateHooksSensorsValue(readHexaValues);
            boolean locked = this.allHooksInState(FcsEnumerations.LockStatus.LOCKED);
            this.lockStatus = this.oneHookInError() ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.LOCKED : (this.allHooksInState(FcsEnumerations.LockStatus.UNLOCKED) ? FcsEnumerations.LockStatus.UNLOCKED : (this.allHooksInState(FcsEnumerations.LockStatus.INTRAVEL) ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
            if (this.initialized && locked && this.isAtClampedPosition()) {
                this.lockStatus = FcsEnumerations.LockStatus.CLAMPED;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void updateHooksSensorsValue(String[] hexaValues) {
        for (LoaderHookModule hook : this.hooks) {
            hook.updateStateWithSensors(hexaValues);
        }
    }

    private boolean oneHookInError() {
        boolean bool = false;
        for (LoaderHookModule hook : this.hooks) {
            bool = bool || hook.getLockStatus() == FcsEnumerations.LockStatus.ERROR;
        }
        return bool;
    }

    private boolean allHooksInState(FcsEnumerations.LockStatus status) {
        boolean bool = true;
        for (LoaderHookModule hook : this.hooks) {
            bool = bool && hook.getLockStatus() == status;
        }
        return bool;
    }

    private int readForceSensor() {
        return 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.hooksController.readCurrent();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp position in reading controller.")
    public void updatePosition() {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String listHooks() {
        StringBuilder sb = new StringBuilder("Hooks status:");
        sb.append("\n");
        for (LoaderHookModule hook : this.hooks) {
            sb.append(hook.toString());
            sb.append("/");
            sb.append(hook.getLockStatus());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(this.getName() + "Sensors values=");
        sb.append("/");
        for (LoaderHookModule hook : this.hooks) {
            sb.append(hook.listSensorsValues());
            sb.append("/");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.initialized) {
            sb.append(" is INITIALIZED.");
        } else {
            sb.append(" is NOT INITIALIZED.");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display clamp info.")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/timeoutForClosingHooks=");
        sb.append(this.timeoutForClosingHooks);
        sb.append("/timeoutForClosingHooksStrongly=");
        sb.append(this.timeoutForClampingHooks);
        sb.append("/timeoutForOpeningHooks=");
        sb.append(this.timeoutForOpeningHooks);
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setName(this.getName());
        status.setPosition(this.position);
        status.setCurrent(this.readCurrent);
        status.setClampState(this.lockStatus);
        status.setForce(this.force);
        status.setHomingDone(this.initialized);
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByLoaderClamp status = this.createStatusDataPublishedByLoaderClamp();
        KeyValueData kvd = new KeyValueData("loaderClamp", (Serializable)status);
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }
}

