/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

public class InclinometerModule
extends Module {
    private final String plutoGatewayName;
    private PlutoGatewayInterface plutoGateway;
    private double inclinaison;

    public InclinometerModule(String plutoGatewayName) {
        this.plutoGatewayName = plutoGatewayName;
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayInterface)this.getComponentLookup().getComponentByName(this.plutoGatewayName);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the inclinometer and returns inclinaison.")
    public double readInclinaison() {
        this.updateInclinaison();
        return this.inclinaison;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads the inclinometer and returns inclinaison.")
    public void updateInclinaison() {
        this.inclinaison = InclinometerModule.convertVoltage2Degree(this.plutoGateway.readNewAnalogValue() / 10);
    }

    public static double convertVoltage2Degree(int voltage) {
        if (voltage < 0 || voltage > 5) {
            throw new IllegalArgumentException("Voltage has to be between 0.5 and 4.5.");
        }
        double sin_angle = ((double)voltage - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }
}

