/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;

public class FilterManager
extends Module {
    private final List<Filter> filters = new ArrayList<Filter>();
    protected TreeMap<String, Filter> filtersMapByName;
    private TreeMap<Integer, Filter> filtersMapByID;

    public SortedMap<String, Filter> getFiltersMapByName() {
        return (TreeMap)this.filtersMapByName.clone();
    }

    public SortedMap<Integer, Filter> getFiltersMapByID() {
        return (TreeMap)this.filtersMapByID.clone();
    }

    public void initModule() {
        LinkedHashMap map = this.getSubsystem().getComponentLookup().getChildren(this.getName(), Filter.class);
        this.filters.addAll(map.values());
        this.filtersMapByName = new TreeMap();
        this.filtersMapByID = new TreeMap();
        for (Filter f : this.filters) {
            FCSCst.FCSLOG.info((Object)("Add filter to filterManager:" + f.toString()));
            this.filtersMapByName.put(f.getName(), f);
            this.filtersMapByID.put(f.getFilterID(), f);
        }
    }

    public Filter getFilterByName(String filterName) {
        return this.filtersMapByName.get(filterName);
    }

    public Filter getFilterByID(int id) {
        return this.filtersMapByID.get(id);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return filter name which correspond to ID.")
    public String getFilterNameByID(int id) {
        if (this.filtersMapByID.containsKey(id)) {
            return this.filtersMapByID.get(id).getName();
        }
        return null;
    }

    public List<String> getFilterNamesSortedByFilterID() {
        ArrayList<String> namesList = new ArrayList<String>();
        TreeMap<Integer, String> filterNamesByID = new TreeMap<Integer, String>();
        for (Map.Entry<String, Filter> entry : this.filtersMapByName.entrySet()) {
            Filter filter = entry.getValue();
            filterNamesByID.put(filter.getFilterID(), filter.getName());
        }
        namesList.addAll(filterNamesByID.values());
        return namesList;
    }

    protected void checkFilterName(String filterName) {
        if (this.getFilterByName(filterName) == null) {
            throw new IllegalArgumentException("Unknown filter name : " + filterName);
        }
        if (this.getFilterByName(filterName).isUnknown()) {
            throw new IllegalArgumentException("Filter: " + filterName + " is at unknown location.");
        }
        if (this.getFilterByName(filterName).isOut()) {
            throw new IllegalArgumentException("Filter: " + filterName + " is out of the camera.");
        }
    }

    public void setFilterLocation(int filterID, FcsEnumerations.FilterLocation filterLocation) {
        Filter filter = this.filtersMapByID.get(filterID);
        if (filter == null) {
            throw new IllegalArgumentException("Unknown filter ID : " + filterID);
        }
        filter.setFilterLocation(filterLocation);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns name of filter on autochanger trucks if there is a filter on trucks,null otherwise.")
    public String getFilterOnAutochangerName() {
        String filterName = null;
        for (Map.Entry<String, Filter> entry : this.filtersMapByName.entrySet()) {
            Filter filter = entry.getValue();
            if (!"AC".equals(filter.getSocketName())) continue;
            return entry.getKey();
        }
        return filterName;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Publish filters data to refresh GUI.")
    public void publishData() {
        for (Map.Entry<String, Filter> entry : this.filtersMapByName.entrySet()) {
            Filter filter = entry.getValue();
            filter.publishData();
        }
    }

    @Command(alias="printFilterList", type=Command.CommandType.QUERY, level=0, description="Return a printed list of filters.")
    public String toString() {
        return this.filtersMapByName.toString();
    }
}

