/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterLocator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class FcsMainModule
extends MainModule
implements FilterLocator {
    private static final long serialVersionUID = 7669526660659959402L;
    private final BridgeToHardware bridgeToLoader;
    private final CarouselModule carousel;
    private final AutoChangerModule autochanger;
    private final LoaderModule loader;
    private final FilterManager filterManager;

    public FcsMainModule(BridgeToHardware bridge, BridgeToHardware bridgeToLoader, FilterManager filterMg, CarouselModule carousel, AutoChangerModule autochanger, LoaderModule loader) {
        super(bridge);
        this.bridgeToLoader = bridgeToLoader;
        this.carousel = carousel;
        this.autochanger = autochanger;
        this.loader = loader;
        this.filterManager = filterMg;
    }

    @Override
    public CarouselModule getCarousel() {
        return this.carousel;
    }

    @Override
    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    @Override
    public void updateFCSState() {
        if (this.carousel.isInitialized() && this.autochanger.isInitialized() && this.loader.isInitialized()) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.HARDWARE_READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    public String getOnlineFilterName() {
        if (!this.autochanger.isEmpty() && this.autochanger.isAtOnline() && this.autochanger.isHoldingFilter()) {
            return this.autochanger.getFilterOnTrucksName();
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns the name of the filter which is at ONLINE.")
    public String printFilterONLINEName() {
        if (this.getOnlineFilterName() != null) {
            return this.getOnlineFilterName();
        }
        return "NONE";
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="returns the filter which has for name the String given as argument.")
    public Filter getFilterByName(String filterName) {
        return this.filterManager.getFilterByName(filterName);
    }

    @Override
    public void initModule() {
        super.initModule();
        FCSCst.FCSLOG.info((Object)"[FcsMainModule] Initializing the FCS Main module ");
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the changer is connected.")
    public boolean isChangerConnected() {
        return this.bridge.isCWrapperConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isCWrapperConnected();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the changer is ready.")
    public boolean isChangerReady() {
        return this.bridge.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the hardware of the loader is ready.")
    public boolean isLoaderReady() {
        return this.bridgeToLoader.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Disconnect the loader hardware.")
    public void disconnectLoader() {
        this.bridgeToLoader.disconnectHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the loader hardware.")
    public void connectLoader() throws HardwareException {
        this.bridgeToLoader.connectHardware();
    }

    public void checkFilterName(String aName) {
        this.filterManager.checkFilterName(aName);
    }

    public void checkAutochangerTrucksLocation() {
        this.autochanger.updateTrucksPosition();
        if (this.autochanger.isAtOnline() && this.autochanger.isHoldingFilter() && this.autochanger.isOnlineClampsLocked()) {
            String filterName = this.filterManager.getFilterOnAutochangerName();
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + filterName.substring(6, filterName.length()))), FcsEnumerations.FilterReadinessState.READY});
        } else if (this.autochanger.isHoldingFilter() && this.autochanger.isOnlineClampsLocked()) {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)"ONLINE_NONE"), FcsEnumerations.FilterReadinessState.READY});
        } else {
            this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)"ONLINE_NONE"), FcsEnumerations.FilterReadinessState.NOT_READY});
        }
    }

    @Override
    @Command(level=1, description="Return the list of LOADER CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public List<String> listLoaderHardwareNames() {
        return this.bridgeToLoader.listHardwareNames();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(this.carousel.toString());
        sb.append(this.autochanger.toString());
        return sb.toString();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Move filter to ONLINE position.", alias="setFilterONLINE", timeout=60)
    public void setFilter(String letter) {
        String filterName = "filter" + letter;
        FCSCst.FCSLOG.info((Object)(this.getName() + ": filter to move is " + filterName));
        if (filterName.equals(this.getOnlineFilterName())) {
            FCSCst.FCSLOG.info((Object)(filterName + " is already at ONLINE."));
            return;
        }
        Filter filterToSet = this.getFilterByName(filterName);
        if (filterToSet == null) {
            throw new IllegalArgumentException(this.getName() + ": Unknown filter name : " + filterName);
        }
        if (filterToSet.isUnknown() || filterToSet.isOut()) {
            throw new RejectedCommandException(this.getName() + ": can't setFilter " + filterName + " ONLINE because filter location is " + filterToSet.getFilterLocation());
        }
        if (filterToSet.isOnCarousel()) {
            FCSCst.FCSLOG.info((Object)(this.getName() + ":" + filterName + " is on carousel."));
            this.carouselMoveFilterToStandby(filterToSet);
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + ":" + filterName + " is on autochanger."));
        this.autochangerMoveFilterToOnline(filterToSet);
        this.saveFilterLocation();
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + letter)), FcsEnumerations.FilterReadinessState.READY});
        FCSCst.FCSLOG.info((Object)(filterName + " is ONLINE."));
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="change subsystem state.")
    public void changeState(String state) {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.valueOf((String)state), FcsEnumerations.FilterReadinessState.READY});
        FCSCst.FCSLOG.fine((Object)("SUBSYSTEM STATE=" + this.getSubsystem().isInState((Enum)FcsEnumerations.FilterState.valueOf((String)state))));
    }

    private void carouselMoveFilterToStandby(Filter filter) {
        assert (filter.isOnCarousel()) : "carouselMoveFilterToStandby has to be called when filter is on Carousel";
        if (this.carousel.isAtStandby(filter)) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " filter:" + filter.getName() + " is at STANDBY position. No need to rotate carousel."));
        } else {
            FCSCst.FCSLOG.info((Object)(this.getName() + ":" + filter.getName() + " is on carousel but not at STANDBY position. Need to rotate carousel."));
            if (!this.autochanger.isEmpty() && this.autochanger.getFilterOnTrucksID() != filter.getFilterID()) {
                FCSCst.FCSLOG.info((Object)(this.autochanger.getFilterOnTrucksName() + " is on autochanger. It has to be stored on carousel."));
                if (!this.autochanger.isAtOnline() && !this.autochanger.isAtHandoff()) {
                    this.autochanger.goToHandOff();
                }
                this.carousel.rotateEmptySocketAtStandby();
                this.autochangerStoreFilterOnCarousel();
            }
            this.autochanger.goToHandOff();
            FCSCst.FCSLOG.info((Object)(this.getName() + ": can be rotated to STANDBY to set " + filter.getName()));
            this.carousel.rotateSocketToStandby(filter.getSocketName());
        }
    }

    private void autochangerMoveFilterToOnline(Filter filter) {
        if (!this.autochanger.isEmpty() && this.autochanger.getFilterOnTrucksID() != filter.getFilterID()) {
            String msg = this.getName() + ": autochanger is loaded with another filter than " + filter.getName();
            FCSCst.FCSLOG.error((Object)msg);
            throw new FailedCommandException(msg);
        }
        if (this.autochanger.isEmpty() && this.carousel.isAtStandby(filter)) {
            FCSCst.FCSLOG.info((Object)(this.getName() + ":" + filter.getName() + " is at STANDBY"));
            this.autochanger.goToStandby();
            this.autochanger.grabFilterAtStandby();
            if (this.autochanger.getFilterOnTrucksID() != filter.getFilterID()) {
                throw new FailedCommandException("FilterID at STANDBY is not consistant with filterID in FCS memory.");
            }
            this.carousel.ungrabFilterAtStandby(filter.getName());
        } else if (this.autochanger.getFilterOnTrucksID() == filter.getFilterID()) {
            FCSCst.FCSLOG.info((Object)(this.getName() + ":" + filter.getName() + " is already on autochanger Trucks."));
        }
        this.autochanger.goToOnline();
        this.autochanger.lockOnlineClamps();
        this.carousel.releaseClamps();
    }

    private void autochangerStoreFilterOnCarousel() {
        if (this.carousel.isReadyToGrabAFilterAtStandby()) {
            if (this.autochanger.isAtOnline() && this.autochanger.isOnlineClampsLocked()) {
                this.autochanger.unlockOnlineClamps();
            }
        } else {
            throw new FcsHardwareException(this.getName() + " autochanger can't store filter at STANDBY because carousel clamps are not ready to receive a filter.");
        }
        this.autochanger.goToStandby();
        this.carousel.grabFilterAtStandby(this.filterManager.getFilterByID(this.autochanger.getFilterOnTrucksID()));
        this.autochanger.ungrabFilterAtStandby();
    }

    public void loadFilter(Filter aFilter) throws HardwareException {
        if (!this.carousel.isReadyToGrabAFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + " can't load a filter when socket at STANDBY position is not empty and ready.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " autochanger is not empty at STANDOFF position; can't load a filter.");
        }
        this.connectLoader();
        if (!this.loader.isHoldingFilter() || !this.loader.isCarrierAtStoragePosition()) {
            throw new RejectedCommandException(this.getName() + " can't load filter because loader is not holding a filter at storage position.");
        }
        this.loader.goToHandoff();
        this.autochanger.goToHandOff();
        this.autochanger.grabFilterAtHandoff(aFilter);
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        this.loader.openHooks();
        this.loader.goToStorage();
        this.disconnectLoader();
    }

    public void unloadFilter(Filter aFilter) throws HardwareException {
        if (!aFilter.isOnCarousel()) {
            throw new RejectedCommandException(this.getName() + " " + aFilter.getName() + " is not on the carousel, can't unload it.");
        }
        if (!this.carousel.isAtStandby(aFilter)) {
            throw new RejectedCommandException(this.getName() + " " + aFilter.getName() + " is not on the carousel at standby position, can't unload it.");
        }
        if (!this.autochanger.isAtHandoff() || !this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " autochanger is not empty at STANDOFF position; can't unload a filter.");
        }
        this.connectLoader();
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move empty to standby position.");
        this.autochanger.goToStandby();
        this.autochanger.grabFilterAtStandby();
        FCSCst.FCSLOG.info((Object)"=======> Carousel is ungrabbing filter at standby position.");
        this.carousel.ungrabFilterAtStandby(aFilter.getName());
        FCSCst.FCSLOG.info((Object)"=======> Autochanger trucks about to move loaded with the filter to handoff position.");
        this.autochanger.moveFilterToHandoff(aFilter);
        FCSCst.FCSLOG.info((Object)"=======> Carousel about to release Clamps.");
        this.carousel.releaseClamps();
        this.loader.goToHandoff();
        this.loader.closeHooks();
        this.autochanger.ungrabFilterAtHandoff(aFilter);
        this.loader.clampHooks();
        this.loader.goToStorage();
        aFilter.setFilterLocation(FcsEnumerations.FilterLocation.OUT);
        this.disconnectLoader();
    }

    @Override
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.carousel.updateClampsStateWithSensors();
        this.autochanger.updateStateWithSensors();
        if (this.loader.isConnectedOnCamera()) {
            this.loader.updateStateWithSensors();
        }
    }

    public void start() {
        this.checkFiltersLocation();
        this.checkAutochangerTrucksLocation();
    }

    public void shutdownNow() {
        this.saveFilterLocation();
        super.shutdownNow();
    }
}

