/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;

public class FakeFilterHolder
extends Module
implements FilterHolder {
    @ConfigurationParameter(isFinal=true)
    private String plutoGatewayName;
    private PlutoGatewayInterface plutoGateway;
    private ComplementarySensors holdingFilterSensors;
    private NumericSensor holdingFilterSensor;
    private boolean holdingFilter = false;
    private final boolean onlyOneSensor;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public FakeFilterHolder(String plutoGatewayName, NumericSensor holdingFilterSensor0, NumericSensor holdingFilterSensor1) {
        this.plutoGatewayName = plutoGatewayName;
        this.holdingFilterSensors = new ComplementarySensors(holdingFilterSensor0, holdingFilterSensor1);
        this.onlyOneSensor = false;
    }

    public FakeFilterHolder(String plutoGatewayName, NumericSensor holdingFilterSensor) {
        this.plutoGatewayName = plutoGatewayName;
        this.holdingFilterSensor = holdingFilterSensor;
        this.onlyOneSensor = true;
    }

    public void initModule() {
        this.plutoGateway = (PlutoGatewayInterface)this.getComponentLookup().getComponentByName(this.plutoGatewayName);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the fake autochanger is holding the filter. This command doesn't read again the sensor.")
    public boolean isHoldingFilter() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.holdingFilter;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.plutoGateway.checkBooted();
        this.plutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            this.computeState(this.plutoGateway.getHexaValues());
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeState(String[] hexaValues) {
        if (this.onlyOneSensor) {
            this.holdingFilterSensor.updateValue(hexaValues);
            this.holdingFilter = this.holdingFilterSensor.getDigitalValue() == 1;
        } else {
            this.holdingFilterSensors.updateValues(hexaValues);
            this.holdingFilter = this.holdingFilterSensors.isOn();
        }
    }

    public void publishData() {
        KeyValueData kvd = this.onlyOneSensor ? new KeyValueData(this.getName(), (Serializable)Integer.valueOf(this.holdingFilterSensor.getDigitalValue())) : new KeyValueData(this.getName(), (Serializable)Integer.valueOf(this.holdingFilterSensors.getDigitalValue()));
        this.getSubsystem().publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return true;
    }

    @Override
    public boolean isAtStandby() {
        return true;
    }
}

