/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;

public class AutochangerTruckModule
extends Module
implements MovedByEPOSController {
    protected final Lock lock = new ReentrantLock();
    protected NumericSensor handoffPositionSensor;
    protected NumericSensor handoffPositionSensorB;
    protected NumericSensor onlinePositionSensor;
    protected NumericSensor onlinePositionSensorB;
    protected NumericSensor standbyPositionSensor;
    protected NumericSensor standbyPositionSensorB;
    private final ComplementarySensors handoffPositionSensors;
    private final ComplementarySensors onlinePositionSensors;
    private final ComplementarySensors standbyPositionSensors;
    private int position;
    private EPOSController controller;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;
    private boolean standbySensorsInError = false;
    private boolean handoffSensorsInError = false;
    private boolean onlineSensorsInError = false;
    private boolean controllerInFault;

    public AutochangerTruckModule(NumericSensor handoffPositionSensor, NumericSensor handoffPositionSensorB, NumericSensor onlinePositionSensor, NumericSensor onlinePositionSensorB, NumericSensor standbyPositionSensor, NumericSensor standbyPositionSensorB) {
        this.handoffPositionSensor = handoffPositionSensor;
        this.handoffPositionSensorB = handoffPositionSensorB;
        this.onlinePositionSensor = onlinePositionSensor;
        this.onlinePositionSensorB = onlinePositionSensorB;
        this.standbyPositionSensor = standbyPositionSensor;
        this.standbyPositionSensorB = standbyPositionSensorB;
        this.handoffPositionSensors = new ComplementarySensors(this.handoffPositionSensor, this.handoffPositionSensorB);
        this.onlinePositionSensors = new ComplementarySensors(this.onlinePositionSensor, this.onlinePositionSensorB);
        this.standbyPositionSensors = new ComplementarySensors(this.standbyPositionSensor, this.standbyPositionSensorB);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at HANDOFF position.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at ONLINE position.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if truck is at STANDBY position.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Standby are equal. Doesn't read again sensors.")
    public boolean isStandbySensorsInError() {
        return this.standbySensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Handoff are equal.Doesn't read again sensors.")
    public boolean isHandoffSensorsInError() {
        return this.handoffSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant position sensors at Online are equal.Doesn't read again sensors.")
    public boolean isOnlineSensorsInError() {
        return this.onlineSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if position sensors are in error.Doesn't read again sensors.")
    public boolean isPositionSensorsInError() {
        return this.onlineSensorsInError || this.handoffSensorsInError || this.standbySensorsInError;
    }

    public NumericSensor getHandoffPositionSensor() {
        return this.handoffPositionSensor;
    }

    public NumericSensor getHandoffPositionSensorB() {
        return this.handoffPositionSensorB;
    }

    public NumericSensor getOnlinePositionSensor() {
        return this.onlinePositionSensor;
    }

    public NumericSensor getOnlinePositionSensorB() {
        return this.onlinePositionSensorB;
    }

    public NumericSensor getStandbyPositionSensor() {
        return this.standbyPositionSensor;
    }

    public NumericSensor getStandbyPositionSensorB() {
        return this.standbyPositionSensorB;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return truck position.")
    public int getPosition() {
        return this.position;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="return controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the controller is in fault.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public void initModule() {
        ComponentLookup lookup = this.getComponentLookup();
        if (this.getName().contains("Xminus")) {
            this.controller = (EPOSController)lookup.getComponentByName("linearRailSlaveController");
        } else if (this.getName().contains("Xplus")) {
            this.controller = (EPOSController)lookup.getComponentByName("linearRailMasterController");
        } else {
            FCSCst.FCSLOG.error((Object)("ERROR in Autochanger trucks name. Can't find a controller for truck: " + this.getName()));
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update truck position in reading controller.")
    public void updatePosition() {
        this.position = this.controller.readPosition();
        this.publishData();
    }

    protected void updateStateWithSensors(String[] readHexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.handoffPositionSensors.updateValues(readHexaValues);
            this.onlinePositionSensors.updateValues(readHexaValues);
            this.standbyPositionSensors.updateValues(readHexaValues);
            this.atHandoff = this.handoffPositionSensors.isOn();
            this.atOnline = this.onlinePositionSensors.isOn();
            this.atStandby = this.standbyPositionSensors.isOn();
            this.handoffSensorsInError = this.handoffPositionSensors.isInError();
            this.onlineSensorsInError = this.onlinePositionSensors.isInError();
            this.standbySensorsInError = this.standbyPositionSensors.isInError();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    public StatusDataPublishedByAutochangerTruck createStatusDataPublishedByAutoChangerTruck() {
        StatusDataPublishedByAutochangerTruck s = new StatusDataPublishedByAutochangerTruck();
        s.setHandoffInError(this.handoffSensorsInError);
        s.setOnlineInError(this.onlineSensorsInError);
        s.setStandbyInError(this.standbySensorsInError);
        s.setHandoffSensorValue(this.handoffPositionSensors.isOn());
        s.setOnlineSensorValue(this.onlinePositionSensors.isOn());
        s.setStandbySensorValue(this.standbyPositionSensors.isOn());
        s.setPosition(this.position);
        s.setControllerInFault(this.controllerInFault);
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByAutoChangerTruck()));
    }
}

