/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerThreeOnlineClamps
extends MobileItemModule {
    private AutoChangerModule autochanger;
    private final AutochangerOnlineClampModule onlineClampXminus;
    private final AutochangerOnlineClampModule onlineClampXplus;
    private final AutochangerOnlineClampModule onlineClampYminus;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForLockingClamps = 15000L;
    @ConfigurationParameter(description="timeout in milliseconds : if unlocking the clamps last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForUnlockingClamps = 15000L;

    public AutochangerThreeOnlineClamps(AutochangerOnlineClampModule onlineClampXminus, AutochangerOnlineClampModule onlineClampXplus, AutochangerOnlineClampModule onlineClampY) {
        this.onlineClampXminus = onlineClampXminus;
        this.onlineClampXplus = onlineClampXplus;
        this.onlineClampYminus = onlineClampY;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.warning((Object)(this.getName() + ": interrupted in getLockStatus."), (Throwable)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are CLOSED.")
    public boolean isLocked() {
        return this.onlineClampXminus.isClosed() && this.onlineClampXplus.isClosed() && this.onlineClampYminus.isClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the 3 clamps are OPENED.")
    public boolean isUnlocked() {
        return this.onlineClampXminus.isOpened() && this.onlineClampXplus.isOpened() && this.onlineClampYminus.isOpened();
    }

    private boolean isInTravel() {
        return this.onlineClampXminus.isInTravel() && this.onlineClampXplus.isInTravel() && this.onlineClampYminus.isInTravel();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if one of the clamp is in error.")
    public boolean isInError() {
        return this.onlineClampXminus.isInError() || this.onlineClampXplus.isInError() || this.onlineClampYminus.isInError();
    }

    @Override
    public void initModule() {
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready : controllers ready, controllers parameters checked and controllers configured.")
    public boolean isInitialized() {
        return this.onlineClampXminus.isInitialized() && this.onlineClampXplus.isInitialized() && this.onlineClampYminus.isInitialized();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Lock the online clamps.")
    public void lockClamps() {
        if (this.isLocked()) {
            throw new RejectedCommandException(this.name + " is already LOCKED");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS, this.timeoutForLockingClamps);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Unlock the online clamps.")
    public void unlockClamps() {
        if (this.isUnlocked()) {
            throw new RejectedCommandException(this.name + " is already UNLOCKED");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS, this.timeoutForUnlockingClamps);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 3 online clamps.")
    public void testUnlockClamps() throws HardwareException {
        long period = 500L;
        this.onlineClampYminus.checkControllerBeforeAction();
        this.onlineClampXminus.checkControllerBeforeAction();
        this.onlineClampXplus.checkControllerBeforeAction();
        this.onlineClampYminus.executeCurrentRamp(0, this.onlineClampYminus.getCurrentToClamp() / 2, 4, period);
        this.onlineClampXminus.executeCurrentRamp(0, this.onlineClampXminus.getCurrentToClamp() / 2, 4, period);
        this.onlineClampXplus.executeCurrentRamp(0, this.onlineClampXplus.getCurrentToClamp() / 2, 4, period);
        this.autochanger.updateStateWithSensors();
        this.onlineClampYminus.executeCurrentRamp(this.onlineClampYminus.getCurrentToClamp() / 2, this.onlineClampYminus.getCurrentToClamp(), 2, period);
        this.onlineClampXminus.executeCurrentRamp(this.onlineClampXminus.getCurrentToClamp() / 2, this.onlineClampXminus.getCurrentToClamp(), 2, period);
        this.onlineClampXplus.executeCurrentRamp(this.onlineClampXplus.getCurrentToClamp() / 2, this.onlineClampXplus.getCurrentToClamp(), 2, period);
        this.autochanger.updateStateWithSensors();
        this.onlineClampYminus.postAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP);
        this.onlineClampXminus.postAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP);
        this.onlineClampXplus.postAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the 3 online clamps.")
    public void testLockClamps() throws HardwareException {
        long period = 500L;
        this.onlineClampYminus.checkControllerBeforeAction();
        this.onlineClampXminus.checkControllerBeforeAction();
        this.onlineClampXplus.checkControllerBeforeAction();
        this.onlineClampYminus.sendCurrentToController(this.onlineClampYminus.getCurrentToClose());
        this.onlineClampXminus.sendCurrentToController(this.onlineClampXminus.getCurrentToClose());
        this.onlineClampXplus.sendCurrentToController(this.onlineClampXplus.getCurrentToClose());
        this.autochanger.updateStateWithSensors();
        this.onlineClampYminus.executeCurrentRamp(this.onlineClampYminus.getCurrentToClose(), this.onlineClampYminus.getCurrentToClamp() / 2, 4, period);
        this.currentRampTwoClamps(-2000, 2000, 4, period);
        this.autochanger.updateStateWithSensors();
        try {
            this.onlineClampXminus.sendCurrentToController(-2500);
            this.onlineClampXplus.sendCurrentToController(2500);
            this.onlineClampYminus.sendCurrentToController(-3000);
            Thread.sleep(period);
            this.onlineClampXminus.sendCurrentToController(-3000);
            this.onlineClampXplus.sendCurrentToController(3000);
            this.onlineClampYminus.sendCurrentToController(-3000);
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.getName() + "interrupted during sleep:" + ex));
        }
        this.autochanger.updateStateWithSensors();
        this.onlineClampXminus.postAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP);
        this.onlineClampXplus.postAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP);
        this.onlineClampYminus.postAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP);
    }

    private void currentRampTwoClamps(int finalValueXminus, int finalValueXplus, int nbSteps, long period) {
        int stepHeightXminus = finalValueXminus / nbSteps;
        int stepHeightXplus = finalValueXplus / nbSteps;
        for (int i = 1; i < nbSteps; ++i) {
            try {
                int currentValueXminus = stepHeightXminus * i;
                this.onlineClampXminus.sendCurrentToController(currentValueXminus);
                int currentValueXplus = stepHeightXplus * i;
                this.onlineClampXplus.sendCurrentToController(currentValueXplus);
                Thread.sleep(period);
                continue;
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException("testUnlockClamps was interrupted while sleeping " + ex);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the 3 online clamps.")
    public void testCloseClamps() throws HardwareException {
        this.onlineClampXminus.close();
        this.onlineClampXplus.close();
        this.onlineClampYminus.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the 3 online clamps with a small pressure.")
    public void testOpenClamps() throws HardwareException {
        this.onlineClampXminus.open();
        this.onlineClampXplus.open();
        this.onlineClampYminus.open();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the 3 onlineClamps hardware is ready.")
    public boolean isCANDevicesReady() {
        return this.onlineClampXminus.isCANDevicesReady() && this.onlineClampXplus.isCANDevicesReady() && this.onlineClampYminus.isCANDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            return this.isLocked();
        }
        if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            return this.isUnlocked();
        }
        throw new IllegalArgumentException(this.name + " invalid action:" + action);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMPS) {
            this.onlineClampXminus.getController().enable();
            this.onlineClampXplus.getController().enable();
            this.onlineClampYminus.getController().enable();
            this.onlineClampXminus.getController().releaseBrake();
            this.onlineClampXplus.getController().releaseBrake();
            this.onlineClampYminus.getController().releaseBrake();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToClose());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToClose());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToClose());
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMPS) {
            this.onlineClampXminus.getController().enable();
            this.onlineClampXplus.getController().enable();
            this.onlineClampYminus.getController().enable();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToClamp());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToClamp());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToClamp());
            this.onlineClampXminus.getController().releaseBrake();
            this.onlineClampXplus.getController().releaseBrake();
            this.onlineClampYminus.getController().releaseBrake();
            this.onlineClampXminus.getController().writeCurrent(this.onlineClampXminus.getCurrentToOpen());
            this.onlineClampXplus.getController().writeCurrent(this.onlineClampXplus.getCurrentToOpen());
            this.onlineClampYminus.getController().writeCurrent(this.onlineClampYminus.getCurrentToOpen());
        } else {
            throw new IllegalArgumentException(this.name + " invalid action:" + action);
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.onlineClampXminus.abortAction(action, delay);
        this.onlineClampXplus.abortAction(action, delay);
        this.onlineClampYminus.abortAction(action, delay);
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
    }

    public StatusDataPublishedByAutochangerThreeClamps createStatusDataPublishedByThreeClamps() {
        StatusDataPublishedByAutochangerThreeClamps status = new StatusDataPublishedByAutochangerThreeClamps();
        status.setName(this.getName());
        status.setLockStatus(this.lockStatus);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerClamps", (Serializable)this.createStatusDataPublishedByThreeClamps()));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.onlineClampXminus.updateStateWithSensors(hexaValues);
            this.onlineClampXplus.updateStateWithSensors(hexaValues);
            this.onlineClampYminus.updateStateWithSensors(hexaValues);
            this.computeLockStatus();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    private void computeLockStatus() {
        this.lockStatus = this.isInError() ? FcsEnumerations.LockStatus.ERROR : (this.isLocked() ? FcsEnumerations.LockStatus.LOCKED : (this.isUnlocked() ? FcsEnumerations.LockStatus.UNLOCKED : (this.isInTravel() ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN)));
    }
}

