/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutochangerOnlineClampModule
extends MobileItemModule
implements MovedByEPOSController {
    private static final int CURRENT_RAMP_PERIOD = 500;
    private final int timeoutForClosing = 10000;
    private final int timeoutForOpening = 10000;
    private AutoChangerModule autochanger;
    private final EPOSController controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @ConfigurationParameter(description="current to close ONLINE clamp in mA")
    private int currentToClose = 0;
    @ConfigurationParameter(description="current to clamp ONLINE clamp, in mA")
    private int currentToClamp = 0;
    @ConfigurationParameter(description="current to close ONLINE clamp in mA")
    private int currentToOpen = -this.currentToClose;
    @ConfigurationParameter(description="time to hold clamp, in millis")
    private long holdTime = 5000L;
    @ConfigurationParameter(description="time for clamp to lock, in millis")
    private long travelTime = 5000L;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private boolean controllerInFault;
    private volatile boolean initialized;
    private boolean controllerConfigured = false;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;
    private ScheduledFuture<?> currentRampHandle;
    protected final Condition currentRampEnded = this.lock.newCondition();
    protected boolean hasToWaitForEndOfCurrentRamp;

    public AutochangerOnlineClampModule(EPOSController controller, NumericSensor closeSensor, NumericSensor closeSensorC, NumericSensor openSensor, NumericSensor openSensorC, int currentToClose) {
        super(3000);
        this.controller = controller;
        this.closeSensors = new ComplementarySensors(closeSensor, closeSensorC);
        this.openSensors = new ComplementarySensors(openSensor, openSensorC);
        this.currentToClose = currentToClose;
        this.currentToOpen = -currentToClose;
    }

    public EPOSController getController() {
        return this.controller;
    }

    public int getCurrentToClose() {
        return this.currentToClose;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public long getTravelTime() {
        return this.travelTime;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is in fault. Doesn't read controller CPU.")
    public boolean isControllerInFault() {
        return this.controllerInFault;
    }

    @Override
    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns controller name.")
    public String getControllerName() {
        return this.controller.getName();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted, parameters in the controller CPU have been checked and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.autochanger = (AutoChangerModule)this.getComponentLookup().getComponentByName("autochanger");
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        if (this.controller == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> onlineController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null onlineClampController - fix groovy description file.");
        }
        if (this.controller instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.controller)});
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady() && this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForOpening() {
        this.checkConditionsForClosing();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.getName() + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForClosing() {
        if (!this.autochanger.isAtOnline()) {
            throw new RejectedCommandException(this.getName() + " can't be CLOSED if autochanger trucks are not at ONLINE position.");
        }
        if (this.autochanger.isEmpty()) {
            throw new RejectedCommandException(this.getName() + " can't be CLOSED if there is no filter in autochanger trucks.");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Initialize controller and check parameters.")
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.controller.initializeAndCheckHardware();
            this.configureController();
            this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
            this.controller.writeParameters(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        catch (FailedCommandException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        this.initialized = true;
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration, throws an exception.")
    public void checkControllerBeforeAction() {
        this.controller.enable();
        this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        try {
            this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
            this.controller.checkFault();
        }
        catch (HardwareException ex) {
            String msg = this.getName() + " error in parameters ";
            FCSLOG.error((Object)(msg + (Object)((Object)ex)));
            throw new FcsHardwareException(msg + (Object)((Object)ex));
        }
        if (!this.controller.isParametersOK()) {
            String msg = this.getName() + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() throws HardwareException {
        try {
            this.controllerConfigured = false;
            this.controller.activateBrake();
            this.controller.shutdownEPOS();
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            boolean inError;
            this.updatingState = true;
            this.closeSensors.updateValues(hexaValues);
            this.openSensors.updateValues(hexaValues);
            boolean locked = this.closeSensors.isOn();
            boolean unlocked = this.openSensors.isOn();
            boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
            boolean bl = inError = someSensorsInError || locked && unlocked;
            this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (locked ? FcsEnumerations.LockStatus.CLOSED : (unlocked ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP) {
            return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
        }
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
        }
        throw new IllegalArgumentException(this.getName() + " invalid action for ONLINE clamp:" + action);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the ONLINE clamp.")
    public void close() {
        if (this.isClosed()) {
            throw new RejectedCommandException(this.getName() + " is already CLOSED.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP, 10000L);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the ONLINE clamp.")
    public void open() {
        if (this.isOpened()) {
            throw new RejectedCommandException(this.getName() + " is already OPENED.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP, 10000L);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP) {
            this.sendCurrentToController(this.currentToClose);
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            this.sendCurrentToController(this.currentToClamp);
            this.executeCurrentRamp(this.currentToClamp, 0, 4, 500L);
            this.controller.writeCurrent(this.currentToOpen);
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP) {
            this.sendCurrentToController(this.currentToOpen);
        } else {
            throw new IllegalArgumentException(this.getName() + " invalid action for ONLINE clamp:" + action);
        }
    }

    public void sendCurrentToController(int cur) {
        this.checkControllerBeforeAction();
        this.controller.writeCurrent(cur);
        this.controller.releaseBrake();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
        this.controller.activateBrake();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.controller.activateBrake();
        this.controller.writeCurrent(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0005");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "C20");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "0");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8001");
        this.controller.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "8001");
    }

    @Override
    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSLOG.debug((Object)(this.getName() + ":processUpdate from source=" + source.toString() + " ValueUpdate=" + v.getName()));
        if (!(source instanceof EPOSController)) {
            return;
        }
        if (v.getValue() instanceof EmergencyMessage) {
            EmergencyMessage emcyMsg = (EmergencyMessage)v.getValue();
            FCSLOG.debug((Object)(this.getName() + ":EmergencyMessage received from CanOpenProxy=" + emcyMsg.toString()));
            this.processEmergencyMessage(emcyMsg);
        } else if (v.getValue() instanceof String) {
            EPOSController ctrl = (EPOSController)((Object)source);
            String msgFromController = (String)v.getValue();
            if (ctrl.getName().equals(this.controller.getName()) && "faultReset".equals(msgFromController)) {
                this.controllerInFault = false;
                this.publishData();
            }
        }
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setName(this.getName());
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setControllerInFault(this.controllerInFault);
        return status;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.lock.lock();
        try {
            FCSLOG.debug((Object)" => stop writing current");
            this.currentRampEnded.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.currentRampHandle.cancel(true);
        FCSLOG.debug((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp() {
        while (this.hasToWaitForEndOfCurrentRamp) {
            try {
                FCSLOG.debug((Object)" waiting for end of current Ramp");
                this.currentRampEnded.await();
            }
            catch (InterruptedException ex) {
                FCSLOG.debug((Object)(" InterruptedException received=" + ex.toString()));
                break;
            }
        }
        FCSLOG.debug((Object)" STOP WAITING FOR END OF CURRENT RAMP");
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, int nbStep, long period) {
        FCSLOG.debug((Object)"############################");
        FCSLOG.debug((Object)("initialValue=" + initialValue));
        FCSLOG.debug((Object)("finalValue=" + finalValue));
        FCSLOG.debug((Object)("nbStep=" + nbStep));
        FCSLOG.debug((Object)("period=" + period));
        FCSLOG.debug((Object)"############################");
        final int stepHeight = (finalValue - initialValue) / nbStep;
        FCSLOG.debug((Object)("stepHeight=" + stepHeight));
        Runnable currentRamp = new Runnable(){
            private int newCurrentValue;
            {
                this.newCurrentValue = initialValue + stepHeight;
            }

            public boolean finalValueReached() {
                boolean goingUp = stepHeight > 0 && this.newCurrentValue > finalValue;
                boolean goingDown = stepHeight < 0 && this.newCurrentValue < finalValue;
                return goingUp || goingDown;
            }

            @Override
            public void run() {
                if (this.finalValueReached()) {
                    AutochangerOnlineClampModule.this.hasToWaitForEndOfCurrentRamp = false;
                    AutochangerOnlineClampModule.this.cancelCurrentRamp();
                } else {
                    FCSLOG.debug((Object)("current to write to controller =" + this.newCurrentValue));
                    AutochangerOnlineClampModule.this.controller.writeCurrent(this.newCurrentValue);
                    this.newCurrentValue += stepHeight;
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 0L, period, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCurrentRamp(int initialValue, int finalValue, int nbStep, long period) {
        this.lock.lock();
        try {
            this.hasToWaitForEndOfCurrentRamp = true;
            this.writeCurrentRamp(initialValue, finalValue, nbStep, period);
            this.waitForEndOfCurrentRamp();
        }
        finally {
            this.hasToWaitForEndOfCurrentRamp = false;
            this.currentRampEnded.signalAll();
            this.lock.unlock();
        }
    }
}

