/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Observable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTruckModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class AutoChangerTwoTrucksModule
extends MobileItemModule {
    AutochangerTruckModule truckXminus;
    AutochangerTruckModule truckXplus;
    private final int encoderRibbonMinValue = 7469165;
    private final int encoderRibbonMaxValue = 8410000;
    private final int minActualPositionValue = 0;
    private final int maxActualPositionValue = 960000;
    @ConfigurationParameter(description="STANDBY position in micron")
    private final int standbyPosition = 0;
    @ConfigurationParameter(description="HANDOFF position in micron")
    private final int handoffPosition = 958000;
    @ConfigurationParameter(description="ONLINE position in micron")
    private final int onlinePosition = 960000;
    @ConfigurationParameter(description="timeout for trucks motion from ONLINE to STANDBY in milliseconds")
    private final long timeoutForTrucksMotion = 120000L;
    private int current = 0;
    private int speed = 0;
    private int position;
    private int deltaPosition;
    private int absoluteTargetPosition = 0;
    private int relativeTargetPosition = 0;
    private EPOSController linearRailMasterController;
    private EPOSController linearRailSlaveController;
    private AutoChangerModule autochanger;
    private boolean masterControllerInFault = false;
    private boolean slaveControllerInFault = false;
    private boolean homingDone = false;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;

    public AutoChangerTwoTrucksModule(AutochangerTruckModule truckXminus, AutochangerTruckModule truckXplus) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position. Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return 958000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return 0;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return 960000;
    }

    public int getEncoderRibbonMinValue() {
        return 7469165;
    }

    public int getEncoderRibbonMaxValue() {
        return 8410000;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return 120000L;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoffPosition() {
        return this.position == this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnlinePosition() {
        this.getClass();
        return this.position == 960000;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandbyPosition() {
        this.getClass();
        return this.position == 0;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError();
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        this.linearRailMasterController = (EPOSController)lookup.getComponentByName("linearRailMasterController");
        this.linearRailSlaveController = (EPOSController)lookup.getComponentByName("linearRailSlaveController");
        if (this.linearRailMasterController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailMasterController)});
        }
        if (this.linearRailSlaveController instanceof Observable) {
            this.listens(new Observable[]{(Observable)((Object)this.linearRailSlaveController)});
        }
    }

    public void tick() {
        this.publishData();
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        super.checkHardware();
        FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            this.configureControllers();
            this.homing();
            this.linearRailSlaveController.enable();
            this.linearRailMasterController.enable();
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)this.getName(), (Throwable)ex);
        }
        catch (FailedCommandException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)this.getName(), (Throwable)ex);
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(false, (Throwable)ex);
        }
        this.updatePosition();
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.getName() + " Begin configuration of the controllers"));
        this.linearRailMasterController.shutdownEPOS();
        this.linearRailSlaveController.shutdownEPOS();
        AutoChangerTwoTrucksModule.configureDigitalInputOfLinearRails(this.linearRailMasterController);
        AutoChangerTwoTrucksModule.configureDigitalInputOfLinearRails(this.linearRailSlaveController);
        AutoChangerTwoTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailMasterController);
        AutoChangerTwoTrucksModule.configureDigitalOutputOfLinearRails(this.linearRailSlaveController);
        FCSLOG.info((Object)(this.getName() + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.homingDone;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.getName() + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (!this.homingDone) {
            throw new RejectedCommandException(this.getName() + " can't be moved because the homing has not been done yet. ");
        }
        this.autochanger.checkFilterSafetyBeforeMotion();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() {
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.getClass();
        this.moveToAbsoluteTargetPosition(960000);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.getClass();
        this.moveToAbsoluteTargetPosition(0);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument.", alias="mobeABSPos")
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 960000) {
            throw new IllegalArgumentException(this.getName() + "argument has to be between " + 0 + " and " + 960000);
        }
        this.updatePosition();
        if (this.position == targetPosition) {
            FCSLOG.info((Object)(this.getName() + " is already at target position=" + targetPosition));
        } else {
            this.checkConditionsForTrucksMotion();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.getName() + " going to absolute position: " + this.absoluteTargetPosition));
            this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, 120000L);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the relative position given as argument.", alias="moveRELPos")
    public void moveToRelativeTargetPosition(int relativePosition) {
        this.checkConditionsForTrucksMotion();
        if (relativePosition < -2000 || relativePosition > 2000) {
            throw new IllegalArgumentException("relativePosition=" + relativePosition + " Relative position value has to be between -2000 and 2000");
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.updatePosition();
        this.relativeTargetPosition = this.position + relativePosition;
        if (this.relativeTargetPosition < 0 || this.relativeTargetPosition > 960000) {
            throw new IllegalArgumentException(this.name + " actual position + argument has to be between " + 0 + " and " + 960000 + " relativeTargetPosition=" + this.relativeTargetPosition);
        }
        FCSLOG.info((Object)(this.getName() + " going to relative position: " + this.relativeTargetPosition));
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_RELATIVE_POSITION, 120000L);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord("3F");
                break;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.relativeTargetPosition);
                this.linearRailMasterController.writeControlWord("7F");
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    private void enableControllersAndReleaseBrake() {
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        if (!this.linearRailMasterController.isEnabled()) {
            this.linearRailMasterController.enable();
        }
        if (!this.linearRailSlaveController.isEnabled()) {
            this.linearRailSlaveController.enable();
        }
        this.linearRailMasterController.releaseBrake();
        this.linearRailSlaveController.releaseBrake();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)("ABORTING action: " + action.toString()));
        this.linearRailMasterController.off();
        this.linearRailSlaveController.off();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.linearRailSlaveController.activateBrake();
        this.linearRailSlaveController.disable();
        this.linearRailMasterController.activateBrake();
        this.linearRailMasterController.disable();
        FCSLOG.info((Object)(this.getName() + ":" + action.toString() + " completed - doing postAction: checking position sensors."));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            this.checkPositionSensors();
        }
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        this.getClass();
        if (this.absoluteTargetPosition == 0 && !this.atStandby) {
            throw new FailedCommandException(this.name + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.name + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        this.getClass();
        if (this.absoluteTargetPosition == 960000 && !this.atOnline) {
            throw new FailedCommandException(this.name + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Read actual position and do the homing of the master controllerwith this actual position.")
    public void homing() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            FCSLOG.error((Object)(this.getName() + " cant' do homing because controllers are not both initialized:"));
            FCSLOG.info((Object)(this.getName() + this.linearRailSlaveController.toString()));
            FCSLOG.info((Object)(this.getName() + this.linearRailMasterController.toString()));
        }
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.writeParameters(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.linearRailSlaveController.enable();
        FCSLOG.debug((Object)(this.getName() + "==> BEGIN homing of the trucks"));
        int ssiPosition = this.linearRailMasterController.readSSIPosition();
        int offset = ssiPosition - 7469165;
        FCSLOG.debug((Object)(this.getName() + " position=" + ssiPosition + ",offset=" + offset));
        this.linearRailMasterController.defineAbsolutePosition(offset);
        this.linearRailMasterController.off();
        this.linearRailMasterController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.homingDone = true;
        FCSLOG.debug((Object)(this.getName() + " ==> END homing of the trucks"));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.position = this.linearRailMasterController.readPosition();
        this.deltaPosition = this.linearRailMasterController.readPosition() - this.linearRailSlaveController.readPosition();
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Override
    public boolean isCANDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                return this.position == this.absoluteTargetPosition;
            }
            case MOVE_TO_RELATIVE_POSITION: {
                return this.position == this.relativeTargetPosition;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.position = this.linearRailMasterController.readPosition();
            FCSLOG.debug((Object)(this.getName() + " position=" + this.position));
            this.autochanger.updateStateWithSensors();
        }
        catch (ShortResponseToSDORequestException ex) {
            FCSLOG.warning((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
        catch (SDORequestException ex) {
            FCSLOG.error((Object)(this.getName() + "=> SDO ERROR IN READING CONTROLLER:"), (Throwable)ex);
        }
    }

    void updateStateWithSensors(String[] readHexaValues) {
        this.truckXminus.updateStateWithSensors(readHexaValues);
        this.truckXplus.updateStateWithSensors(readHexaValues);
        this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
        this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
        this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalInputOfLinearRails(EPOSController ctl) {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, "0005");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, "30");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, "30");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public static void configureDigitalOutputOfLinearRails(EPOSController ctl) {
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, "000F");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, "0");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, "0002");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, "0004");
        ctl.writeParameterInHexa(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, "8005");
    }

    public StatusDataPublishedByAutoChangerTrucks getStatusData() {
        return this.createStatusDataPublishedByAutoChangerTrucks();
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setPosition(this.position);
        s.setDeltaPosition(this.deltaPosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setHomingDone(this.homingDone);
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(this.getName(), (Serializable)this.getStatusData()));
    }
}

