/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutoChangerModule
extends Module
implements HardwareController,
FilterHolder,
AlertRaiser {
    @ConfigurationParameter
    private String plutoGatewayName;
    private BridgeToHardware bridge;
    private PlutoGatewayInterface plutoGateway;
    private FilterManager filterManager;
    private FilterIdentificator filterIdentificator;
    private final NumericSensor loaderConnectedSensor0;
    private final NumericSensor loaderConnectedSensor1;
    private final ComplementarySensors loaderConnectedSensors;
    private final AutoChangerTwoTrucksModule autochangerTrucks;
    private final AutochangerTwoLatches latches;
    private final AutochangerThreeOnlineClamps onlineClamps;
    private int filterOnTrucksID = 0;
    private FilterHolder carousel;
    private FilterHolder loader;
    private boolean loaderConnectedSensorsInError = false;
    private boolean loaderConnected = false;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    public AutoChangerModule(String plutoGatewayName, NumericSensor loaderConnectedSensor0, NumericSensor loaderConnectedSensor1, AutoChangerTwoTrucksModule trucks, AutochangerTwoLatches latches, AutochangerThreeOnlineClamps onlineClamps) {
        this.plutoGatewayName = plutoGatewayName;
        this.loaderConnectedSensor0 = loaderConnectedSensor0;
        this.loaderConnectedSensor1 = loaderConnectedSensor1;
        this.autochangerTrucks = trucks;
        this.latches = latches;
        this.onlineClamps = onlineClamps;
        this.loaderConnectedSensors = new ComplementarySensors(loaderConnectedSensor0, loaderConnectedSensor1);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return false if the 2 redondant loader sensors are equal.")
    public boolean isLoaderConnectedSensorsInError() {
        return this.loaderConnectedSensorsInError;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if an error has been detected on sensors.")
    public boolean isSensorsInError() {
        return this.latches.isInError() || this.onlineClamps.isInError() || this.autochangerTrucks.isPositionSensorsInError();
    }

    public int getHandoffPosition() {
        return this.autochangerTrucks.getHandoffPosition();
    }

    public int getOnlinePosition() {
        return this.autochangerTrucks.getOnlinePosition();
    }

    public int getStandbyPosition() {
        return this.autochangerTrucks.getStandbyPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filterID, else return 0.")
    public int getFilterOnTrucksID() {
        return this.filterOnTrucksID;
    }

    public void setFilterOnTrucksID(int filterOnTrucksID) {
        this.filterOnTrucksID = filterOnTrucksID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filter name else return null.")
    public String getFilterOnTrucksName() {
        if (this.isHoldingFilter()) {
            return this.filterManager.getFilterNameByID(this.filterOnTrucksID);
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter at ONLINE, return filter name else return null.")
    public String getFilterOnlineName() {
        if (this.isAtOnline() && !this.isEmpty()) {
            return this.filterManager.getFilterNameByID(this.filterOnTrucksID);
        }
        return null;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.getName() + ": has been interrupted while waiting for end of update."));
                }
            }
            boolean bl = this.loaderConnected && !this.loaderConnectedSensorsInError;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carousel is holding the filter at STANDBY position.")
    public boolean isCarouselHoldingFilterAtStandby() {
        return this.carousel.isAtStandby() && this.carousel.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader is connected and holding a filter. This command doesn't read again the sensors.")
    public boolean isLoaderHoldingFilterAtHandoff() {
        if (this.loaderConnected) {
            return this.loader.isHoldingFilter();
        }
        return false;
    }

    public boolean isMoving() {
        return this.autochangerTrucks.isMoving();
    }

    public void initModule() {
        FCSCst.FCSLOG.info((Object)(this.getName() + ": init MODULE"));
        ComponentLookup lookup = this.getSubsystem().getComponentLookup();
        this.plutoGateway = (PlutoGatewayInterface)lookup.getComponentByName(this.plutoGatewayName);
        this.bridge = (BridgeToHardware)lookup.getComponentByName("tcpProxy");
        this.carousel = (FilterHolder)lookup.getComponentByName("carousel");
        this.loader = (FilterHolder)lookup.getComponentByName("loader");
        this.filterManager = (FilterManager)((Object)lookup.getComponentByName("filterManager"));
        this.filterIdentificator = (FilterIdentificator)((Object)lookup.getComponentByName("filterIdentificator"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.bridge.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized and homing of the controllers is done.")
    public boolean isHardwareReady() {
        return this.bridge.isCANDevicesReady() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.autochangerTrucks.isInitialized() && this.latches.isInitialized() && this.onlineClamps.isInitialized();
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " checking hardware."));
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() throws HardwareException {
        FCSCst.FCSLOG.info((Object)(this.getName() + " BEGIN checkStarted"));
        this.bridge.checkHardware();
        try {
            this.plutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
            this.autochangerTrucks.checkHardware();
        }
        catch (FcsHardwareException ex) {
            throw new HardwareException(true, (Throwable)ex);
        }
    }

    public void checkStopped() throws HardwareException {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public void checkConditionsForOpeningLatches() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " checking pre-conditions for opening latches"));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new FcsHardwareException(this.getName() + ": latches are in ERROR state - can't unlockClamps latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.getName() + ": no filter in autochanger - can't open latches.");
        }
        if (!this.autochangerTrucks.isAtStandbyPosition() && !this.autochangerTrucks.isAtHandoffPosition()) {
            throw new RejectedCommandException(this.getName() + ": autochanger is loaded with a filter but is not at handoff position neither at standby - can't open latches.");
        }
        if (this.autochangerTrucks.isAtStandbyPosition()) {
            this.checkConditionsForOpeningLatchesAtStandby();
        } else if (this.autochangerTrucks.isAtHandoffPosition()) {
            this.checkConditionsForOpeningLatchesAtHandoff();
        }
    }

    private void checkLatchesInitialized() {
        if (!this.latches.isInitialized()) {
            throw new RejectedCommandException(this.getName() + ": latches are not intialized. Please initialize hardware first.");
        }
    }

    private void checkConditionsForOpeningLatchesAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + ": autochanger is loaded with a filter and is  at STANDBY position but carousel doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " carousel is holding filter at STANDBY => latches can be open safely."));
    }

    private void checkConditionsForOpeningLatchesAtHandoff() {
        if (!this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(this.getName() + ": autochanger is loaded with a filter and is  at HANDOFF position but loader doesn't hold the filter - can't open latches.");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " loader is holding filter at HANDOFF => latches can be open safely."));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Autochanger latches can be closed.")
    public void checkConditionsForClosingLatches() {
        FCSCst.FCSLOG.info((Object)(this.getName() + " checking conditions for closing latches."));
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError()) {
            throw new RejectedCommandException(this.getName() + ": latches are in ERROR state - can't close latches.");
        }
        if (this.isEmpty()) {
            String message = this.getName() + ": no filter in autochanger - can't close latches.";
            throw new RejectedCommandException(message);
        }
        if (!this.autochangerTrucks.isAtStandbyPosition() && !this.autochangerTrucks.isAtHandoffPosition()) {
            throw new RejectedCommandException(this.getName() + ": autochanger is not at handoff position neither at standby - can't close latches.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if its safe for filters to move autochanger trucks.")
    public void checkFilterSafetyBeforeMotion() {
        String msg = this.getName() + " can't move autochanger trucks because ";
        this.updateStateWithSensors();
        if (this.isSensorsInError()) {
            this.handleSensorsError();
        } else if (this.isEmpty()) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " trucks are empty - can move"));
        } else if (this.isAtStandby()) {
            this.checkFilterSafetyAtStandby(msg);
        } else if (this.isAtHandoff()) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " COUCOU : trucks are empty " + this.isEmpty()));
            this.checkFilterSafetyAtHandoff(msg);
        } else if (this.isAtOnline()) {
            this.checkFilterSafetyAtOnline(msg);
        } else if (!this.isHoldingFilter()) {
            throw new RejectedCommandException(msg + "latches are not LOCKED");
        }
    }

    private void checkFilterSafetyAtStandby(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "both carousel and autochanger are holding filter at STANDBY");
        }
        if (!this.isHoldingFilter() && !this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "neither carousel nor autochanger are holding filter at STANDBY");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " filter safe at STANDBY - can move"));
    }

    private void checkFilterSafetyAtHandoff(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at HANDOFF but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "both loader and autochanger are holding filter at HANDOFF");
        }
        if (!this.isHoldingFilter() && !this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "neither loader nor autochanger are holding filter at HANDOFF");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " filter safe at HANDOFF - can move"));
    }

    private void checkFilterSafetyAtOnline(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at ONLINE but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && this.onlineClamps.isLocked()) {
            throw new RejectedCommandException(message + "both latches and onlineClamps are holding filter at ONLINE - can't move trucks.");
        }
        if (!this.isHoldingFilter() && !this.onlineClamps.isLocked()) {
            throw new RejectedCommandException(message + "neither latches nor onlineClamps are holding filter at HANDOFF");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + " filter safe at ONLINE - can move"));
    }

    private void handleSensorsError() {
        String msg = this.getName() + " error detected in sensors:";
        if (this.autochangerTrucks.isPositionSensorsInError()) {
            msg = msg + " trucks position sensors";
        }
        if (this.latches.isInError()) {
            msg = msg + " latches sensors";
        }
        if (this.onlineClamps.isInError()) {
            msg = msg + " onlineClamps sensors";
        }
        this.raiseAlarm(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, msg);
        throw new FcsHardwareException(msg);
    }

    @Override
    public boolean isHoldingFilter() {
        return !this.latches.isEmpty() && this.latches.isLocked();
    }

    public boolean isOnlineClampsLocked() {
        return this.onlineClamps.isLocked();
    }

    void updateTrucksPosition() {
        this.autochangerTrucks.updatePosition();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.plutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.plutoGateway.updateValues();
            String[] readHexaValues = this.plutoGateway.getHexaValues();
            this.updateStateWithSensors(readHexaValues);
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signalAll();
            this.lock.unlock();
            this.publishData();
            this.autochangerTrucks.publishData();
            this.latches.publishData();
            this.onlineClamps.publishData();
        }
    }

    public void updateStateFromPDO() {
        String[] readHexaValues = this.plutoGateway.readHexaValuesFromPDO();
        this.updateStateWithSensors(readHexaValues);
    }

    private void updateStateWithSensors(String[] readHexaValues) {
        this.loaderConnectedSensors.updateValues(readHexaValues);
        this.loaderConnected = this.loaderConnectedSensors.isOn();
        this.loaderConnectedSensorsInError = this.loaderConnectedSensors.isInError();
        this.autochangerTrucks.updateStateWithSensors(readHexaValues);
        this.latches.updateStateWithSensors(readHexaValues);
        this.onlineClamps.updateStateWithSensors(readHexaValues);
        this.filterIdentificator.updateSensorsValues(readHexaValues);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at HANDOFF. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.autochangerTrucks.isAtHandoffPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at ONLINE. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.autochangerTrucks.isAtOnlinePosition();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at STANDBY. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.autochangerTrucks.isAtStandbyPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the autochanger. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.latches.isEmpty();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Lock ONLINE clamps.")
    public void lockOnlineClamps() {
        this.onlineClamps.lockClamps();
        FCSCst.FCSLOG.info((Object)(this.getName() + ":" + this.getFilterOnTrucksName() + " is LOCKED ONLINE."));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock ONLINE clamps.")
    public void unlockOnlineClamps() {
        this.onlineClamps.unlockClamps();
        FCSCst.FCSLOG.info((Object)(this.getName() + ":" + this.getFilterOnTrucksName() + " is UNLOCKED ONLINE."));
    }

    void goToHandOff() {
        this.autochangerTrucks.goToHandOff();
    }

    void goToStandby() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.autochangerTrucks.goToStandby();
    }

    void goToOnline() {
        this.getSubsystem().updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.autochangerTrucks.goToOnline();
    }

    void grabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void ungrabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void moveFilterToHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(type=Command.CommandType.ACTION, alias="grabFilter", level=1, description="Go to STANDBY to grab filter and stay at STANDBY.")
    public void grabFilterAtStandby() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.getName() + ": can't grab a filter when trucks are not at STANDBY.");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + ": grabbing a filter at standby position."));
        this.latches.close();
        this.filterOnTrucksID = this.identifyFilterAtStandby();
        this.filterManager.setFilterLocation(this.filterOnTrucksID, FcsEnumerations.FilterLocation.AUTOCHANGER);
        this.publishData();
        FCSCst.FCSLOG.info((Object)(this.getName() + ": filter " + this.filterOnTrucksID + " is grabbed on autochanger"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(level=1, description="Ungrab filter at STANDBY", type=Command.CommandType.ACTION)
    public void ungrabFilterAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + ": can't ungrab a filter at STANDBY when carousel is not holding filter.");
        }
        FCSCst.FCSLOG.info((Object)(this.getName() + ": ungrabing filter at standby position."));
        this.latches.open();
        AutoChangerModule autoChangerModule = this;
        synchronized (autoChangerModule) {
            this.filterManager.setFilterLocation(this.filterOnTrucksID, FcsEnumerations.FilterLocation.CAROUSEL);
            this.filterOnTrucksID = 0;
        }
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open both Latches.")
    public void openLatches() {
        this.latches.open();
    }

    private int identifyFilterAtStandby() {
        return this.filterIdentificator.readFilterIdentifier();
    }

    public void tick() {
        this.publishData();
    }

    public StatusDataPublishedByAutoChanger createStatusDataPublishedByAutoChanger() {
        StatusDataPublishedByAutoChanger status = new StatusDataPublishedByAutoChanger();
        status.setName(this.getName());
        status.setLoaderConnectedSensorValue0(this.loaderConnectedSensor0.getDigitalValue());
        status.setLoaderConnectedSensorValue1(this.loaderConnectedSensor1.getDigitalValue());
        status.setLoaderConnectedSensorsInError(this.isLoaderConnectedSensorsInError());
        return status;
    }

    public void publishData() {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerGeneral", (Serializable)this.createStatusDataPublishedByAutoChanger()));
    }
}

