/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import java.security.SecureRandom;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsUtilsTest
extends CcsTestCaseTemplate {
    private final SecureRandom randomGenerator = new SecureRandom();
    private static final String nodeID1 = "24A";
    private static final String nodeID2 = "02F4A";
    private static final String nodeID3 = "3";

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBinaryToHex() {
        System.out.println("binaryToHex");
        String bin = "0";
        String expResult = "0";
        String result = FcsUtils.binaryToHex((String)bin);
        Assert.assertEquals((String)"binaryToHex of 0 is 0", (Object)expResult, (Object)result);
        bin = "1111111111111111";
        expResult = "ffff";
        result = FcsUtils.binaryToHex((String)bin);
        Assert.assertEquals((String)("binaryToHex of " + bin + " is " + expResult), (Object)expResult, (Object)result);
        bin = "01000001";
        expResult = "41";
        result = FcsUtils.binaryToHex((String)bin);
        Assert.assertEquals((String)("binaryToHex of " + bin + " is " + expResult), (Object)expResult, (Object)result);
        bin = "10000000";
        expResult = "80";
        result = FcsUtils.binaryToHex((String)bin);
        Assert.assertEquals((String)("binaryToHex of " + bin + " is " + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testHexToBinary() {
        System.out.println("hexToBinary");
        String Hex = "4";
        String expResult = "00000100";
        String result = FcsUtils.hexToBinary((String)Hex);
        Assert.assertEquals((Object)expResult, (Object)result);
        Hex = "AA";
        expResult = "10101010";
        result = FcsUtils.hexToBinary((String)Hex);
        Assert.assertEquals((Object)expResult, (Object)result);
        Hex = "FF";
        expResult = "11111111";
        result = FcsUtils.hexToBinary((String)Hex);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testTwoBytesInHexaToBinary() {
        System.out.println("twoBytesInHexaToBinary");
        String twoBytesInHexa = "4";
        String expResult = "0000000000000100";
        String result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
        twoBytesInHexa = "AA";
        expResult = "0000000010101010";
        result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
        twoBytesInHexa = "F0F0";
        expResult = "1111000011110000";
        result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testReplaceDigit() {
        System.out.println("replaceDigit");
        String twoBytesInHexa = "FFF";
        int bitPosition = 15;
        String digit = "0";
        String expResult = "fff";
        String result = FcsUtils.replaceDigit((String)twoBytesInHexa, (int)bitPosition, (String)digit);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testForce2zero() {
        System.out.println("force2zero");
        String hexaVal = "ffff";
        int pos = 15;
        String expResult = "7fff";
        String result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        System.out.println("force2zero(\"ffff\", 15)=" + result);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0000";
        pos = 15;
        expResult = "0";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0";
        pos = 15;
        expResult = "0";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff";
        pos = 15;
        expResult = "ff";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "7fff";
        pos = 15;
        expResult = "7fff";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "afff";
        pos = 15;
        expResult = "2fff";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff00";
        pos = 15;
        expResult = "7f00";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0";
        pos = 0;
        expResult = "0";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "1";
        pos = 0;
        expResult = "0";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff01";
        pos = 0;
        expResult = "ff00";
        result = FcsUtils.force2zero((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testForce2one() {
        System.out.println("force2one");
        String hexaVal = "ffff";
        int pos = 15;
        String expResult = "ffff";
        String result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0000";
        pos = 15;
        expResult = "8000";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        System.out.println("force2one(\"0\", 15)=" + result);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0";
        pos = 15;
        expResult = "8000";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff";
        pos = 15;
        expResult = "80ff";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "7fff";
        pos = 15;
        expResult = "ffff";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "afff";
        pos = 15;
        expResult = "afff";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff00";
        pos = 15;
        expResult = "ff00";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "0";
        pos = 0;
        expResult = "1";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
        hexaVal = "ff00";
        pos = 0;
        expResult = "ff01";
        result = FcsUtils.force2one((String)hexaVal, (int)pos);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testBuildWsdoCommand() {
        System.out.println("buildWsdoCommand");
        String nodeID = "30";
        String index = "1003";
        String subindex = "40";
        String size = "2";
        String data = "f80";
        String expResult = "wsdo,30,1003,40,2,f80";
        String result = FcsUtils.buildWsdoCommand((String)nodeID, (String)index, (String)subindex, (String)size, (String)data);
        Assert.assertEquals((String)("buildWsdoCommand(nodeID,index,subindex,size,data) must be=" + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testCheckCanOpenCommand() {
        String msgInvalid = "- An IllegalArgumentException should have been raised.";
        String msgExcRaised = "- IllegalArgumentException is raised with message: ";
        String msgValid = " is a valid CANopen command.";
        System.out.println("#checkCanOpenCommand");
        String command = null;
        try {
            FcsUtils.checkCommand(command);
            Assert.fail((String)("null command " + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("null command " + msgExcRaised + ex);
        }
        try {
            command = "";
            FcsUtils.checkCommand((String)command);
            Assert.fail((String)("empty command " + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("empty command " + msgExcRaised + ex);
        }
        try {
            command = "toto";
            FcsUtils.checkCommand((String)command);
            Assert.fail((String)(command + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(command + msgExcRaised + ex);
        }
        try {
            command = "coucou,toto";
            FcsUtils.checkCommand((String)command);
            Assert.fail((String)(command + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(command + msgExcRaised + ex);
        }
        try {
            command = "sync";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "scan";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "quit";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "info,24A";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "reset,02F4A";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "rsdo,3,1002,20";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "wsdo,3,1002,20,2,56478";
            FcsUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
    }

    @Test
    public void testBuildRsdoCommand() {
        System.out.println("buildRsdoCommand");
        String nodeID = "30";
        String index = "1003";
        String subindex = "01";
        String expResult = "rsdo,30,1003,01";
        String result = FcsUtils.buildRsdoCommand((String)nodeID, (String)index, (String)subindex);
        Assert.assertEquals((String)("buildRsdoCommand(nodeID,index,subindex) must be=" + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testCheckSocketName() {
        System.out.println("checkSocketName");
        String msg = "is a valid socket name - should NOT have raised exception:";
        String name = "";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "AC";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("AC" + msg + ex));
        }
        name = "socket1";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket2";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket5";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        msg = " is an invalid socket name - IllegalArgumentException should be raised.";
        name = "COUCOU";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "1";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket12";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketb";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketBidon";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket0";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket6";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testCreateStatusDataPublishedByHardware() throws Exception {
        System.out.println("createStatusDataPublishedByHardware");
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testFcsUtils");
        PieceOfHardware device = (PieceOfHardware)s.getComponentLookup().getComponentByName("device");
        StatusDataPublishedByHardware result = FcsUtils.createStatusDataPublishedByHardware((PieceOfHardware)device);
        result.setBooted(true);
        Assert.assertTrue((String)"device is booted", (boolean)result.isBooted());
        String expResult = "device/isBooted=true/isInitialized=false";
        Assert.assertEquals((String)"device status=", (Object)expResult, (Object)result.toString());
    }

    @Test
    public void testCreateStatusDataPublishedByEPOSController() throws Exception {
        System.out.println("createStatusDataPublishedByEPOSController");
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testFcsUtils");
        String controllerName = "controller";
        EPOSController ctlr = (EPOSController)s.getComponentLookup().getComponentByName(controllerName);
        StatusDataPublishedByEPOSController result = FcsUtils.createStatusDataPublishedByEPOSController((EPOSController)ctlr);
        Assert.assertFalse((boolean)result.isEnabled());
        Assert.assertEquals((String)"Controller name is :controller", (Object)controllerName, (Object)result.getName());
    }

    @Test
    public void testToReverseBinary() {
        int i;
        System.out.println("toReverseBinary");
        int decimal = 0;
        int[] expResult = new int[16];
        for (int i2 = 0; i2 < expResult.length; ++i2) {
            expResult[i2] = 0;
        }
        int[] result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"0 reste 0", (int[])expResult, (int[])result);
        decimal = 1;
        expResult = new int[16];
        expResult[0] = 1;
        for (i = 1; i < expResult.length; ++i) {
            expResult[i] = 0;
        }
        result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"1 devient 1000000000000000", (int[])expResult, (int[])result);
        decimal = 2;
        expResult = new int[16];
        expResult[0] = 0;
        expResult[1] = 1;
        for (i = 2; i < expResult.length; ++i) {
            expResult[i] = 0;
        }
        result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"2 devient 0100000000000000", (int[])expResult, (int[])result);
    }

    @Test
    public void testConvertToInteger16() {
        System.out.println("convertToInteger16");
        int unsigned16 = 0;
        int expResult = 0;
        int result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=0 =>INTEGER16=0", (long)expResult, (long)result);
        unsigned16 = 2356;
        expResult = 2356;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=2356 =>INTEGER16=2356", (long)expResult, (long)result);
        unsigned16 = 65342;
        expResult = -193;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65342 =>INTEGER16=-193", (long)expResult, (long)result);
        unsigned16 = Short.MAX_VALUE;
        expResult = Short.MAX_VALUE;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32767 =>INTEGER16=32767", (long)expResult, (long)result);
        unsigned16 = 32768;
        expResult = -32767;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32768 =>INTEGER16=-32767", (long)expResult, (long)result);
        unsigned16 = 65535;
        expResult = 0;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65535 =>INTEGER16=0", (long)expResult, (long)result);
        unsigned16 = -400;
        expResult = -400;
        result = FcsUtils.convertToInteger16((int)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=-400 =>INTEGER16=-400", (long)expResult, (long)result);
    }

    @Test
    public void testAddAngle() {
        System.out.println("addAngle");
        int angle1 = 0;
        int angle2 = 0;
        int expResult = 0;
        int result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(0,0) is 0", (long)expResult, (long)result);
        angle1 = 360;
        angle2 = 0;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(360,0) is 0", (long)expResult, (long)result);
        angle1 = 0;
        angle2 = 360;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(0,360) is 0", (long)expResult, (long)result);
        angle1 = 360;
        angle2 = 360;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(360,360) is 0", (long)expResult, (long)result);
        angle1 = -360;
        angle2 = 0;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(-360,0) is 0", (long)expResult, (long)result);
        angle1 = 0;
        angle2 = -360;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(0,-360) is 0", (long)expResult, (long)result);
        angle1 = -360;
        angle2 = -360;
        expResult = 0;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(-360,-360) is 0", (long)expResult, (long)result);
        angle1 = 0;
        angle2 = 72;
        expResult = 72;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(0,72) is 72", (long)expResult, (long)result);
        angle1 = 0;
        angle2 = -72;
        expResult = 288;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(0,-72) is 288", (long)expResult, (long)result);
        angle1 = -350;
        angle2 = -340;
        expResult = 30;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertEquals((String)"addAngle(-350,-340) is 30", (long)expResult, (long)result);
        int a = this.randomGenerator.nextInt(360);
        int b = this.randomGenerator.nextInt(360);
        System.out.println("addAngle tested with a=" + a + " and b=" + b);
        angle1 = a;
        angle2 = b;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always >= 0"), (result >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always < 360"), (result < 360 ? 1 : 0) != 0);
        Assert.assertEquals((String)"addAngle is commutative", (long)FcsUtils.addAngle((int)angle1, (int)angle2), (long)FcsUtils.addAngle((int)angle2, (int)angle1));
        angle1 = -a;
        angle2 = b;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always > 0"), (result > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always < 360"), (result < 360 ? 1 : 0) != 0);
        Assert.assertEquals((String)"addAngle is commutative", (long)FcsUtils.addAngle((int)angle1, (int)angle2), (long)FcsUtils.addAngle((int)angle2, (int)angle1));
        angle1 = a;
        angle2 = -b;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always > 0"), (result > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always < 360"), (result < 360 ? 1 : 0) != 0);
        Assert.assertEquals((String)"addAngle is commutative", (long)FcsUtils.addAngle((int)angle1, (int)angle2), (long)FcsUtils.addAngle((int)angle2, (int)angle1));
        angle1 = -a;
        angle2 = -b;
        result = FcsUtils.addAngle((int)angle1, (int)angle2);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always > 0, angle1=" + angle1 + " angle2=" + angle2), (result > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("addAngle(" + a + "," + b + ") is always < 360"), (result < 360 ? 1 : 0) != 0);
        Assert.assertEquals((String)"addAngle is commutative", (long)FcsUtils.addAngle((int)angle1, (int)angle2), (long)FcsUtils.addAngle((int)angle2, (int)angle1));
    }

    @Test
    public void testComputeRotationShortestWay() {
        System.out.println("computeRotationShortestWay");
        int angle = 0;
        int expResult = 0;
        int result = FcsUtils.computeRotationShortestWay((int)angle);
        Assert.assertEquals((String)"for an angle=0 shortest way is 0", (long)expResult, (long)result);
        for (int i = 0; i < 20; ++i) {
            angle = i % 2 == 0 ? this.randomGenerator.nextInt(360) : -this.randomGenerator.nextInt(360);
            result = FcsUtils.computeRotationShortestWay((int)angle);
            Assert.assertTrue((String)("we should have : |computeRotationShortestWay()| <= 180 but was:" + result), (Math.abs(result) <= 180 ? 1 : 0) != 0);
        }
    }
}

