/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenSensor14bits;

public class SimuCanOpenSensor14bitsTest
extends CcsTestCaseTemplate {
    @Test
    public void testSetNewRange() {
        int aValue1 = 0;
        int aValue2 = 3500;
        System.out.println("***************************************");
        System.out.println("setNewRange : " + aValue1 + " -- " + aValue2);
        SimuCanOpenSensor14bits instance = new SimuCanOpenSensor14bits("ai814", 7);
        instance.setNewRange(aValue1, aValue2);
        instance.readNewValue();
        Assert.assertTrue((String)"The new read value should be less than aValue2.", (instance.readNewValue() <= aValue2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The new read value should be greater than aValue1.", (instance.readNewValue() >= aValue1 ? 1 : 0) != 0);
    }

    @Test
    public void testReadNewValue() {
        System.out.println("readNewValue");
        int aValue1 = 0;
        int aValue2 = 4095;
        SimuCanOpenSensor14bits instance = new SimuCanOpenSensor14bits("ai814", 5);
        instance.setNewRange(aValue1, aValue2);
        for (int i = 0; i < 10; ++i) {
            int result = instance.readNewValue();
            System.out.println("value result=" + result);
            if (result >= aValue1 && result <= aValue2) continue;
            Assert.fail((String)"result out of range");
        }
        try {
            instance.setNewRange(aValue2, aValue1);
            Assert.fail((String)"setNewRange: second argument must be greater than first argument. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("readNewValue throws an Exception and it was right to do it:" + ex);
        }
        try {
            instance.setNewRange(-300, aValue2);
            Assert.fail((String)"setNewRange: first argument must be > 0. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("readNewValue throws an Exception and it was right to do it:" + ex);
        }
        try {
            instance.setNewRange(aValue2, 32768);
            Assert.fail((String)"setNewRange: second argument must be < SENSOR14BITS_MAX. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("readNewValue throws an Exception and it was right to do it:" + ex);
        }
        try {
            instance.setNewRange(-1, 200);
            Assert.fail((String)"setNewRange: first argument must be > SENSOR14BITS_MIN. Should raise Exception");
        }
        catch (IllegalArgumentException ex) {
            System.out.println("readNewValue throws an Exception and it was right to do it:" + ex);
        }
    }
}

