/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTwoTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerLatchModule;
import org.lsst.ccs.subsystems.fcs.AutochangerMainModule;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTruckModule;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerStandalonePlutoGateway;

public class SimuAutochangerPlutoGatewayTest {
    private static final String PLUTOGATEWAY_NAME = "acPlutoGateway";
    private static Subsystem autochangerSubsystem = null;
    private static AutochangerMainModule main;
    private static AutoChangerModule autochanger;
    private static AutoChangerTwoTrucksModule trucks;
    private static AutochangerTruckModule acTruckXminus;
    private static AutochangerTwoLatches latches;
    private static AutochangerLatchModule latchXplus;
    private static AutochangerThreeOnlineClamps onlineClamps;
    private static SimuAutochangerStandalonePlutoGateway plutoGateway;
    private static ComplementarySensors filterEngagedSensorsLatchXminus;
    private static ComplementarySensors filterEngagedSensorsLatchXplus;
    private static ComplementarySensors lockSensorsLatchXplus;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF SimuAutochangerPlutoGateway   ");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        autochangerSubsystem = BootUtils.getSubsystemFromFile((String)"autochanger__simulation");
        autochangerSubsystem.start();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = autochangerSubsystem.getComponentLookup();
        main = (AutochangerMainModule)lookup.getComponentByName("main");
        autochanger = (AutoChangerModule)lookup.getComponentByName("autochanger");
        autochanger.updateStateWithSensors();
        trucks = (AutoChangerTwoTrucksModule)lookup.getComponentByName("autochangerTrucks");
        acTruckXminus = (AutochangerTruckModule)lookup.getComponentByName("acTruckXminus");
        plutoGateway = (SimuAutochangerStandalonePlutoGateway)lookup.getComponentByName(PLUTOGATEWAY_NAME);
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoffPosition());
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        latchXplus = (AutochangerLatchModule)lookup.getComponentByName("latchXplus");
        onlineClamps = (AutochangerThreeOnlineClamps)lookup.getComponentByName("onlineClamps");
        Assert.assertTrue((String)"After initialization phase, simulated hardware should be ready.", (boolean)main.isCANDevicesReady());
        filterEngagedSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXminus");
        filterEngagedSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXplus");
        lockSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("lockSensorsLatchXplus");
    }

    @AfterClass
    public static void after() throws Exception {
        autochangerSubsystem.shutdown();
        autochangerSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() {
        System.out.println("***********  BEFORE test : setUp    *******************");
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSimulateAutochangerTrucksIsAtHandoff() {
        System.out.println("###simulateAutochangerTrucksIsAtHandoff");
        plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at HANDOFF", (boolean)trucks.isAtHandoffPosition());
    }

    @Test
    public void testSimulateAutochangerTrucksIsOnline() {
        System.out.println("###simulateAutochangerTrucksIsOnline");
        plutoGateway.simulateAutochangerTrucksIsOnline();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at ONLINE", (boolean)trucks.isAtOnlinePosition());
    }

    @Test
    public void testSimulateAutochangerTrucksIsAtStandby() {
        System.out.println("###simulateAutochangerTrucksIsAtStandby");
        plutoGateway.simulateAutochangerTrucksIsAtStandby();
        trucks.updatePosition();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"AutochangerTrucks should be at STANDBY", (boolean)trucks.isAtStandbyPosition());
    }

    @Test
    public void testSimulateLoaderIsConnected() {
        System.out.println("### simulateLoaderIsConnected");
        plutoGateway.simulateLoaderIsConnected();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"loader should be connected", (boolean)autochanger.isLoaderConnected());
    }

    @Test
    public void testSimulateLoaderIsDisconnected() {
        System.out.println("### simulateLoaderIsDisconnected");
        plutoGateway.simulateLoaderIsDisconnected();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"loader should NOT be connected", (boolean)autochanger.isLoaderConnected());
    }

    @Test
    public void testSimulateFilterIsOnAutochanger() {
        System.out.println("### simulateFilterIsOnAutochanger");
        plutoGateway.simulateFilterIsOnAutochanger();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger should be on Autochanger", (boolean)autochanger.isEmpty());
    }

    @Test
    public void testSimulateAutochangerIsEmpty() {
        System.out.println("### simulateAutochangerIsEmpty");
        plutoGateway.simulateAutochangerIsEmpty();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger should be empty", (boolean)autochanger.isEmpty());
    }

    @Test
    public void testSimulateAutochangerLatchesAreLocked() {
        System.out.println("### simulateAutochangerLatchesAreLocked");
        plutoGateway.simulateAutochangerLatchesAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"Latches should be LOCKED", (boolean)latches.isLocked());
    }

    @Test
    public void testSimulateAutochangerLatchesAreUnlocked() {
        System.out.println("### simulateAutochangerLatchesAreUnlocked");
        plutoGateway.simulateAutochangerLatchesAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"Latches should be UNLOCKED", (boolean)latches.isLocked());
    }

    @Test
    public void testSimulateAutochangerLatchIsLocked() {
        System.out.println("### simulateAutochangerLatchIsLocked");
        plutoGateway.simulateAutochangerLatchIsLocked(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"latchXplus is LOCKED", (boolean)latchXplus.isLocked());
    }

    @Test
    public void testSimulateAutochangerLatchIsUnlocked() {
        System.out.println("### simulateAutochangerLatchIsUnlocked");
        plutoGateway.simulateAutochangerLatchIsUnlocked(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"latchXplus is UNLOCKED", (boolean)latchXplus.isLocked());
    }

    @Test
    public void testSimulateLatchLockSensorsInError() {
        System.out.println("### simulateLockSensorsInError");
        plutoGateway.simulateLatchLockSensorsInError(latchXplus.getName());
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"lockSensorsLatchXplus should be in error", (boolean)lockSensorsLatchXplus.isInError());
    }

    @Test
    public void testSimulateAutochangerOnlineClampsAreLocked() {
        System.out.println("### simulateAutochangerOnlineClampsAreLocked");
        plutoGateway.simulateAutochangerOnlineClampsAreLocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"ONLINE clamps should be LOCKED", (boolean)onlineClamps.isLocked());
    }

    @Test
    public void testSimulateAutochangerOnlineClampsAreUnlocked() {
        System.out.println("### simulateAutochangerOnlineClampsAreUnlocked");
        plutoGateway.simulateAutochangerOnlineClampsAreUnlocked();
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"ONLINE clamps should be UNLOCKED", (boolean)onlineClamps.isUnlocked());
    }

    @Test
    public void testSimuComplementarySensorsOn() {
        System.out.println("###simuComplementarySensorsOn");
        plutoGateway.simuComplementarySensorsOn(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXminus are ON", (boolean)filterEngagedSensorsLatchXminus.isOn());
        plutoGateway.simuComplementarySensorsOn(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXplus are ON", (boolean)filterEngagedSensorsLatchXplus.isOn());
    }

    @Test
    public void testSimuComplementarySensorsNotOn() {
        System.out.println("###simuComplementarySensorsNotOn");
        plutoGateway.simuComplementarySensorsNotOn(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"filterEngagedSensorsLatchXminus are NOT ON", (boolean)filterEngagedSensorsLatchXminus.isOn());
        plutoGateway.simuComplementarySensorsNotOn(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertFalse((String)"filterEngagedSensorsLatchXplus are NOT ON", (boolean)filterEngagedSensorsLatchXplus.isOn());
    }

    @Test
    public void testSimuComplementarySensorsInError() {
        System.out.println("###simuComplementarySensorsInError");
        plutoGateway.simuComplementarySensorsInError(filterEngagedSensorsLatchXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXminus are in Error", (boolean)filterEngagedSensorsLatchXminus.isInError());
        plutoGateway.simuComplementarySensorsInError(filterEngagedSensorsLatchXplus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"filterEngagedSensorsLatchXplus are in Error", (boolean)filterEngagedSensorsLatchXplus.isInError());
    }

    @Test
    public void testSimulateACTruckIsAtHandoff() {
        System.out.println("simulateACTruckIsAtHandoff");
        plutoGateway.simulateACTruckIsAtHandoff(acTruckXminus);
        autochanger.updateStateWithSensors();
        Assert.assertTrue((String)"acTruckXminus should be at HANDOFF", (boolean)acTruckXminus.isAtHandoff());
    }
}

