/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenProxy;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderClampModule clamp;
    private static LoaderCarrierModule carrier;
    private static LoaderModule loader;
    private static SimuLoaderClampController clampController;
    private static SimuLoaderCarrierController carrierController;
    private static SimuLoaderStandalonePlutoGateway gateway;
    private static SimuCanOpenProxy tcpProxy;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF LOADER IN STANDALONE MODE");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.start();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        clamp = (LoaderClampModule)lookup.getComponentByName("clamp");
        clampController = (SimuLoaderClampController)lookup.getComponentByName("hooksController");
        carrier = (LoaderCarrierModule)lookup.getComponentByName("carrier");
        carrierController = (SimuLoaderCarrierController)lookup.getComponentByName("carrierController");
        loader = (LoaderModule)lookup.getComponentByName("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName("loaderPlutoGateway");
        tcpProxy = (SimuCanOpenProxy)lookup.getComponentByName("loaderTcpProxy");
    }

    @Before
    public void setUp() {
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsLocked();
        gateway.simulateLoaderIsConnectedOnCamera();
        loader.updateStateWithSensors();
    }

    @Test
    public void testGoToHomePosition() {
        System.out.println("*** test of homing of the clamp (goToHomePosition) ***");
        gateway.simulateFilterIsNotOnLoader();
        loader.updateStateWithSensors();
        clamp.goToHomePosition();
        Assert.assertTrue((String)"clamp is at Home Position", (boolean)clamp.isAtHomePosition());
        clamp.checkInitialized();
    }

    @Test
    public void testCheckSensorsOK() {
        System.out.println("*** test of checkCheckSensorsOK of class LoaderClampModule ***");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is in Error", (boolean)clamp.isInError());
        try {
            clamp.checkSensorsOK();
            Assert.fail((String)"Clamps sensors are in error. An Exception should have been raised.");
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Clamps sensors are in error. Raised exception:" + ex);
        }
    }

    @Test
    public void testCheckConditionsToGoToHomePosition() {
        System.out.println("*** test of checkConditionsToGoToHomePosition ***");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is in Error", (boolean)clamp.isInError());
        try {
            clamp.checkConditionsToGoToHomePosition();
            Assert.fail((String)"Clamps sensors are in error. Can't goToHomePosition an Exception should have been raised.");
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Clamps sensors are in error. Raised exception:" + ex);
        }
    }

    @Test
    public void testCheckConnectedOnCamera() {
        System.out.println("*** checkConnectedOnCamera");
        gateway.simulateLoaderIsConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is connected on camera", (boolean)loader.isConnectedOnCamera());
        loader.checkConnectedOnCamera();
        gateway.simulateLoaderIsNotConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"loader is NOT connected on camera", (boolean)loader.isConnectedOnCamera());
        try {
            loader.checkConnectedOnCamera();
            Assert.fail((String)"loader is NOT connected on camera");
        }
        catch (Exception ex) {
            System.out.println("loader is not connected on camera. Exception raised=" + ex);
        }
    }

    @Test
    public void testInitializeHardware() throws HardwareException {
        System.out.println("*** test of initializeHardware (goToHomePosition) ***");
        gateway.simulateFilterIsNotOnLoader();
        loader.initializeHardware();
        Assert.assertTrue((String)"clamp is initialized", (boolean)clamp.isInitialized());
        Assert.assertTrue((String)"clamp is at Home Position", (boolean)clamp.isAtHomePosition());
    }

    @Test
    public void testIsInError() {
        System.out.println("*** test of isInError ***");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertEquals((String)"clamp state is UNKNOWN", (Object)clamp.getLockStatus(), (Object)FcsEnumerations.LockStatus.UNKNOWN);
        Assert.assertTrue((String)"clamp is in Error", (boolean)clamp.isInError());
    }

    @Test
    public void testCarrierController() {
        System.out.println("*** tests on carrierController ***");
        Assert.assertEquals((String)"carrierController.getName() is carrier.getControllerName()", (Object)carrierController.getName(), (Object)carrier.getControllerName());
        EmergencyMessage emcy = new EmergencyMessage(tcpProxy.getName(), carrierController.getNodeID(), carrierController.getName(), "10", "Error10", "350", "ERROR 350");
        carrier.processEmergencyMessage(emcy);
        Assert.assertTrue((String)"carrierController is in fault", (boolean)carrier.isControllerInFault());
        carrier.processFaultReset();
        Assert.assertFalse((String)"carrierController is NOT in fault", (boolean)carrier.isControllerInFault());
    }

    @Test
    public void testCarrierReadPosition() {
        System.out.println("*** tests of readPosition of class LoaderCarrierModule ***");
        int posInitial = carrier.getPosition();
        Assert.assertEquals((String)"in simulation readPosition should not change position", (long)posInitial, (long)carrier.readPosition());
    }

    @Test
    public void testIsCarrierAtStoragePosition() {
        System.out.println("*** isCarrierAtStoragePosition");
        Assert.assertTrue((String)"Carrier is at STORAGE position", (boolean)loader.isCarrierAtStoragePosition());
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdown();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Test
    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT loaderTest.py ***");
        System.out.println("************************************************");
        Assert.assertTrue((String)"loaderSubsystem should be in OPERATIONAL phase.", (boolean)loaderSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/loaderTest.py", (String[])new String[0]);
    }

    static {
        loaderSubsystem = null;
    }
}

