/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

public class CanOpenProxyTest
extends CcsTestCaseTemplate {
    private static Subsystem s;
    private static CanOpenProxy tcpProxy;
    private static CanOpenDevice device1;
    private static CanOpenDevice device2;
    private static CanOpenDevice device3;
    private static final String deviceName1 = "device1";
    private static final String deviceName2 = "device2";
    private static final String deviceName3 = "device3";
    private static final String nodeID1 = "24A";
    private static final String nodeID2 = "02F4A";
    private static final String nodeID3 = "3";
    private static final String nodeID4 = "3a";
    private static final String serial1 = "8XFFV678";
    private static final String serial2 = "99xfr56A";
    private static final String serial3 = "033fzbgt4";
    private static final String infoMessage1 = "info,24A,type, vendor, productCode, revision,8XFFV678";
    private static final String infoMessage2 = "info,02F4A,type, vendor, productCode, revision,99xfr56A";
    private static final String infoMessage3 = "info,3,type, vendor, productCode, revision,033fzbgt4";

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenProxy");
        System.out.println("***************************************");
        s = BootUtils.getSubsystemFromFile((String)"testCOP");
        ComponentLookup lookup = s.getComponentLookup();
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("main");
        device1 = (CanOpenDevice)lookup.getComponentByName(deviceName1);
        device2 = (CanOpenDevice)lookup.getComponentByName(deviceName2);
        device3 = (CanOpenDevice)lookup.getComponentByName(deviceName3);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        System.out.println("********* end of CanOpenProxy tests *************");
        if (s.getState(PhaseState.class) != null && !s.isInState((Enum)PhaseState.OFF_LINE)) {
            s.shutdown();
            s.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 10L, TimeUnit.SECONDS);
        }
    }

    @Before
    public void setUp() {
        tcpProxy.initialize();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSetHardwareList() {
        System.out.println("#setHardwareList");
        CanOpenProxy instance = tcpProxy;
        Assert.assertEquals((String)"There is 3 devices in hardwareList.", (long)3L, (long)instance.hardwareMapByNodeID.size());
    }

    @Test
    public void testGetMyClientName() {
        System.out.println("#getMyClientName");
        CanOpenProxy instance = tcpProxy;
        String expResult = "testFCS";
        String result = instance.getMyClientName();
        Assert.assertEquals((String)"Client name = testFCS", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetPdoStorage() {
        System.out.println("#getPdoStorage");
        CanOpenProxy instance = tcpProxy;
        String expResult = "PDO STORAGE:(SIZE=0){}";
        String result = instance.getPdoStorage().toString();
        Assert.assertEquals((String)"PDO Storage should be empty.", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetNodeName() {
        System.out.println("#getNodeName");
        CanOpenProxy instance = tcpProxy;
        String expResult = deviceName1;
        String result = instance.getNodeName(nodeID1);
        Assert.assertEquals((String)"Name of device1 isdevice1", (Object)expResult, (Object)result);
        expResult = deviceName2;
        result = instance.getNodeName(nodeID2);
        Assert.assertEquals((String)"Name of device2 isdevice2", (Object)expResult, (Object)result);
        String fakeNodeID = "fakeNodeID";
        result = instance.getNodeName(fakeNodeID);
        System.out.println("Result=" + result);
        expResult = "UnknownDevice" + fakeNodeID;
        Assert.assertEquals((String)(fakeNodeID + "is unbooted."), (Object)expResult, (Object)result);
    }

    @Test
    public void testListNodes() {
        System.out.println("#listNodes");
        CanOpenProxy instance = tcpProxy;
        String expResult = "main: no booted CANopen devices.";
        String result = instance.listBootedNodes();
        Assert.assertEquals((String)"There should be none booted nodes.", (Object)expResult, (Object)result);
        instance.processBootMessage(nodeID1);
        expResult = "main booted CANopen devices:{24A=Node ID= 24A (in decimal= 586)/ type=0/ vendor=0/ product code=0/ revision=0/ serial number=0}";
        result = instance.listBootedNodes();
        Assert.assertEquals((String)"There should be a booted node now.", (Object)expResult, (Object)result);
    }

    @Test
    public void testIsHardwareReady() {
        System.out.println("#isHardwareReady");
        CanOpenProxy instance = tcpProxy;
        boolean expResult = false;
        boolean result = instance.isCANDevicesReady();
        Assert.assertEquals((String)"isHardwareReady returns false because the tcp server is not started", (Object)expResult, (Object)result);
    }

    @Test
    public void testProcessBootMessage() {
        System.out.println("#processBootMessage");
        CanOpenProxy instance = tcpProxy;
        boolean result = instance.isBooted(nodeID1);
        Assert.assertFalse((String)"24A is not yet booted", (boolean)result);
        instance.processBootMessage(nodeID1);
        boolean result2 = instance.isBooted(nodeID1);
        Assert.assertTrue((String)"24A is booted now", (boolean)result2);
    }

    @Test
    public void testProcessEmcyMessage() {
        System.out.println("#processEmcyMessage");
        String message1 = "emcy,24A,00,00";
        String message2 = "emcy,001a,00,00";
        CanOpenProxy instance = tcpProxy;
        try {
            instance.processEmcyMessage(message1);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NullPointerException));
        }
        try {
            instance.processEmcyMessage(message2);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof NullPointerException));
        }
    }

    @Test
    public void testProcessInfoMessage() {
        System.out.println("#processInfoMessage");
        CanOpenProxy instance = tcpProxy;
        instance.processBootMessage(nodeID3);
        boolean result = instance.isBooted(nodeID3);
        Assert.assertTrue((String)"3 is booted now.", (boolean)result);
        instance.processBootMessage(nodeID3);
        instance.processInfoMessage(infoMessage3, nodeID3);
        CanOpenNode bootedNode = instance.getBootedNodeBySerialNumber(serial3);
        String expResult = bootedNode.getSerialNB();
        Assert.assertEquals((String)"Serial number of node3 should now be 033fzbgt4", (Object)expResult, (Object)serial3);
    }

    @Test
    public void testProcessUnknownCommand() {
        System.out.println("#processUnknownCommand");
        String message = "Unknown,COUCOU";
        CanOpenProxy instance = tcpProxy;
        try {
            instance.processUnknownCommand(message);
            System.out.println("AlertState=" + s.getState());
            Assert.assertTrue((String)"s should be in AlertState.ALARM", (boolean)s.isInState((Enum)AlertState.ALARM));
        }
        catch (NullPointerException ex) {
            System.out.println(ex);
            System.out.println("When an unknown message is received from the CANbus, an ALARM of type WARNING is raised.A NullPointerException is raised because getSubsystem() is null.");
        }
    }

    @Test
    public void testProcessResponseToReadSDO() {
        System.out.println("#processResponseToReadSDO");
        String response = "rsdo,3a,00,ff";
        String nodeID = nodeID4;
        String request = "rsdo,3a,1003,01";
        String expResult = "ff";
        try {
            String result = tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.assertEquals((String)("response to" + request + " is " + expResult), (Object)expResult, (Object)result);
        }
        catch (Exception ex) {
            System.out.println("Should not raised an Exception:" + ex);
        }
        response = "rsdo,3a,06010000,ff";
        nodeID = nodeID4;
        request = "rsdo,3a,1003,01";
        expResult = "ff";
        try {
            tcpProxy.processResponseToReadSDO(response, nodeID, request);
            Assert.fail((String)("response to" + request + " is not" + expResult));
        }
        catch (NullPointerException | SDORequestException ex) {
            System.out.println("response to" + request + " is not" + expResult + " should raised an Exception:" + ex);
        }
        catch (ShortResponseToSDORequestException ex) {
            System.out.println("Should raised an Exception of type SDORequestException:" + (Object)((Object)ex));
        }
    }

    @Test
    public void testCheckBootedCanOpenNodes() {
        System.out.println("#checkCanOpenNodes");
        CanOpenProxy instance = tcpProxy;
        try {
            instance.checkBootedCanOpenNodes();
            Assert.fail((String)"An Exception of type HardwareException should have been raised.");
        }
        catch (NullPointerException | HardwareException ex) {
            System.out.println(ex);
        }
        instance.processBootMessage(nodeID1);
        try {
            instance.checkBootedCanOpenNodes();
            Assert.fail((String)"An Exception of type HardwareException should have been raised");
        }
        catch (NullPointerException | HardwareException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testCheckNumberOfBootedNodes() {
        System.out.println("#checkNumberOfBootedNodes");
        CanOpenProxy instance = tcpProxy;
        try {
            instance.checkNumberOfBootedNodes();
            Assert.fail((String)"No hardware is booted :an Exception of type HardwareException should have been raised.");
        }
        catch (NullPointerException | HardwareException ex) {
            System.out.println(ex);
        }
        instance.processBootMessage(nodeID1);
        instance.processBootMessage(nodeID2);
        instance.processBootMessage(nodeID3);
        try {
            instance.checkNumberOfBootedNodes();
        }
        catch (HardwareException ex) {
            Assert.fail((String)("3 nodes are booted. No hardware exception should have been raised." + (Object)((Object)ex)));
        }
    }

    @Test
    public void testCheckHardwareID() {
        System.out.println("#checkHardwareID");
        CanOpenProxy instance = tcpProxy;
        instance.processBootMessage(nodeID1);
        instance.checkHardwareID((PieceOfHardware)device1);
        Assert.assertTrue((String)"s should be in AlertState.ALARM", (boolean)s.isInState((Enum)AlertState.ALARM));
        s.clearAllAlerts();
        instance.processInfoMessage(infoMessage1, nodeID1);
        try {
            instance.checkHardwareID((PieceOfHardware)device1);
        }
        catch (NullPointerException ex) {
            System.out.println(ex);
            System.out.println("The node is booted and serial number is OK. A NullPointerException is raised because we want to publish data but getSubsystem() is null.");
            Assert.assertTrue((String)"24A is booted", (boolean)tcpProxy.isBooted(nodeID1));
        }
        instance.processBootMessage(nodeID2);
        String message = "info,02F4A,type, vendor, productCode, revision,XXXX000YYY";
        instance.processInfoMessage(message, nodeID2);
        instance.checkHardwareID((PieceOfHardware)device2);
        Assert.assertTrue((String)"nodeID2 is booted but with a wrong serial number so subsystem should be in AlertState.ALARM", (boolean)s.isInState((Enum)AlertState.ALARM));
        s.clearAllAlerts();
        instance.checkHardwareID((PieceOfHardware)device3);
        Assert.assertTrue((String)"nodeID3 is not booted so subsystem should be in AlertState.ALARM", (boolean)s.isInState((Enum)AlertState.ALARM));
        s.clearAllAlerts();
        instance.processBootMessage(nodeID4);
        message = "info,3a,type, vendor, productCode, revision,033fzbgt4";
        instance.processInfoMessage(message, nodeID4);
        instance.checkHardwareID((PieceOfHardware)device3);
        Assert.assertTrue((String)"deviceName3 is booted but with another CANopen ID", (boolean)s.isInState((Enum)AlertState.ALARM));
    }

    @Test
    public void testGetBootedNodeBySerialNumber() {
        System.out.println("getBootedNodeBySerialNumber");
        CanOpenProxy instance = tcpProxy;
        Object expResult = null;
        CanOpenNode result = instance.getBootedNodeBySerialNumber(serial1);
        Assert.assertEquals((String)"No CANopen node is booted yet.", expResult, (Object)result);
        instance.processBootMessage(nodeID2);
        instance.processInfoMessage(infoMessage2, nodeID2);
        CanOpenNode result2 = instance.getBootedNodeBySerialNumber(serial2);
        Assert.assertEquals((String)"A CANopen node is booted now and has serial number:99xfr56A", (Object)serial2, (Object)result2.getSerialNB());
    }

    @Test
    public void testPrintBootedNodeBySerialNumber() {
        System.out.println("printBootedNodeBySerialNumber");
        CanOpenProxy instance = tcpProxy;
        try {
            String sn = null;
            instance.printBootedNodeBySerialNumber(sn);
            Assert.fail((String)"An Exception of type IllegalArgumentException should have been raised.");
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        try {
            instance.processBootMessage(nodeID1);
            instance.processInfoMessage(infoMessage1, nodeID1);
            String expResult = "Node ID= 24A (in decimal= 586)/ type=type/ vendor= vendor/ product code= productCode/ revision= revision/ serial number=8XFFV678";
            String result = instance.printBootedNodeBySerialNumber(serial1);
            Assert.assertEquals((String)"Booted node is 24A", (Object)expResult, (Object)result);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"Serial number:8XFFV678 is not null.");
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        CanOpenProxy instance = tcpProxy;
        String expResult = "main/port=53000/clientName=testFCS/hardwareBootTimeout=10000";
        String result = instance.toString();
        Assert.assertEquals((String)"toString method should returns:main/port=53000/clientName=testFCS/hardwareBootTimeout=10000", (Object)expResult, (Object)result);
    }
}

