/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CanOpenNumericSensorTest
extends CcsTestCaseTemplate {
    private static final String dioName1 = "dio1";
    private static final int inputNumero1 = 3;
    private static final String dioName2 = "dio2";
    private static final int inputNumero2 = 5;
    private static final int byteNumero2 = 1;
    private static CanOpenNumericSensor sensor1;
    private static CanOpenNumericSensor sensor2;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenNumericSensor");
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testCanOpenNumericSensor");
        sensor1 = (CanOpenNumericSensor)s.getComponentLookup().getComponentByName("sensor1");
        sensor2 = (CanOpenNumericSensor)s.getComponentLookup().getComponentByName("sensor2");
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CanOpenNumericSensor tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetByteNumero() {
        System.out.println("getByteNumero");
        int expResult = 0;
        int result = sensor1.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor1 is 0", (long)expResult, (long)result);
        expResult = 1;
        result = sensor2.getByteNumero();
        Assert.assertEquals((String)"byteNumero of sensor2 is 1", (long)expResult, (long)result);
    }

    @Test
    public void testGetInputNumero() {
        System.out.println("getInputNumero");
        int expResult = 3;
        int result = sensor1.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor1 is 3", (long)expResult, (long)result);
        expResult = 5;
        result = sensor2.getInputNumero();
        Assert.assertEquals((String)"inputNumero of sensor2 is 5", (long)expResult, (long)result);
    }

    @Test
    public void testUpdateValue_String() {
        System.out.println("updateValue");
        sensor1.updateValue("FF");
        Assert.assertEquals((String)"new digital value of sensor1 is now 1", (long)1L, (long)sensor1.getDigitalValue());
        sensor1.updateValue("0");
        Assert.assertEquals((String)"new digital value of sensor1 is now 0", (long)0L, (long)sensor1.getDigitalValue());
        String bin = "00001000";
        sensor1.updateValue(FcsUtils.binaryToHex((String)bin));
        Assert.assertEquals((String)"new digital value of sensor1 is now 1", (long)1L, (long)sensor1.getDigitalValue());
        sensor2.updateValue("FF");
        Assert.assertEquals((String)"new digital value of sensor2 is now 1", (long)1L, (long)sensor2.getDigitalValue());
        sensor2.updateValue("0");
        Assert.assertEquals((String)"new digital value of sensor2 is now 0", (long)0L, (long)sensor2.getDigitalValue());
    }

    @Test
    public void testUpdateValue_StringArr() {
        System.out.println("updateValue");
        String[] hexaValues = new String[]{"FF", "FF", "FF"};
        sensor1.updateValue(hexaValues);
        Assert.assertEquals((String)"new digital value of sensor1 is now 1", (long)1L, (long)sensor1.getDigitalValue());
        sensor2.updateValue(hexaValues);
        Assert.assertEquals((String)"new digital value of sensor2 is now 1", (long)1L, (long)sensor2.getDigitalValue());
        String[] hexaValues2 = new String[]{"FF", "0", "FF"};
        sensor2.updateValue(hexaValues2);
        Assert.assertEquals((String)"new digital value of sensor2 is now 0", (long)0L, (long)sensor2.getDigitalValue());
        String bin = "00100000";
        String[] hexaValues4 = new String[]{"0", FcsUtils.binaryToHex((String)bin)};
        sensor2.updateValue(hexaValues4);
        Assert.assertEquals((String)"new digital value of sensor2 is now 1", (long)1L, (long)sensor2.getDigitalValue());
        String[] hexaValues3 = new String[]{"00", "FF", "FF"};
        sensor1.updateValue(hexaValues3);
        Assert.assertEquals((String)"new digital value of sensor1 is now 0", (long)0L, (long)sensor1.getDigitalValue());
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        String expResult = "sensor1/DIO module=dio1/Input numero=3/byteNumero=0/digitalValue=0";
        String result = sensor1.toString();
        Assert.assertEquals((String)("printed sensor1 is " + expResult), (Object)expResult, (Object)result);
        expResult = "sensor2/DIO module=dio2/Input numero=5/byteNumero=1/digitalValue=0";
        result = sensor2.toString();
        Assert.assertEquals((String)("printed sensor2 is " + expResult), (Object)expResult, (Object)result);
    }
}

