/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

public class ComplementarySensorsTest {
    static ComplementarySensors sensors;
    static CanOpenNumericSensor sensor;
    static CanOpenNumericSensor sensorC;
    static String[] hexaValues;

    @BeforeClass
    public static void setUpClass() {
        int inputNumero = 0;
        int byteNumero = 0;
        int inputNumeroC = 1;
        int byteNumeroC = 0;
        sensor = new CanOpenNumericSensor("gateway", inputNumero, byteNumero);
        sensorC = new CanOpenNumericSensor("gateway", inputNumeroC, byteNumeroC);
        sensors = new ComplementarySensors((NumericSensor)sensor, (NumericSensor)sensorC);
        ComplementarySensorsTest.hexaValues[0] = "1";
        sensors.updateValues(hexaValues);
        System.out.println("sensor=" + sensor.toString());
        System.out.println("sensorC=" + sensorC.toString());
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private void printSensors() {
        System.out.println("sensor=" + sensor.toString());
        System.out.println("sensorC=" + sensorC.toString());
    }

    @Test
    public void testIsInError() {
        System.out.println("*****isInError");
        ComplementarySensorsTest.hexaValues[0] = "0";
        sensors.updateValues(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"Sensors are in error", (boolean)sensors.isInError());
        ComplementarySensorsTest.hexaValues[0] = "1";
        sensors.updateValues(hexaValues);
        this.printSensors();
        Assert.assertFalse((String)"Sensors are NOT in error", (boolean)sensors.isInError());
    }

    @Test
    public void testIsOn() {
        System.out.println("****isOn");
        ComplementarySensorsTest.hexaValues[0] = "1";
        sensors.updateValues(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"sensors are ON", (boolean)sensors.isOn());
        ComplementarySensorsTest.hexaValues[0] = "2";
        sensors.updateValues(hexaValues);
        this.printSensors();
        Assert.assertFalse((String)"sensors are NOT ON", (boolean)sensors.isOn());
    }

    @Test
    public void testGetDigitalValue() {
        System.out.println("*****getDigitalValue");
        ComplementarySensorsTest.hexaValues[0] = "1";
        sensors.updateValues(hexaValues);
        Assert.assertEquals((String)"sensors digital value is 1", (long)1L, (long)sensors.getDigitalValue());
        ComplementarySensorsTest.hexaValues[0] = "2";
        sensors.updateValues(hexaValues);
        Assert.assertEquals((String)"sensors digital value is 0", (long)0L, (long)sensors.getDigitalValue());
    }

    @Test
    public void testUpdateValues() {
        System.out.println("*****updateValues");
        ComplementarySensorsTest.hexaValues[0] = "1";
        sensors.updateValues(hexaValues);
        this.printSensors();
        Assert.assertTrue((String)"sensors are ON", (boolean)sensors.isOn());
    }

    static {
        hexaValues = new String[1];
    }
}

