package autochanger

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder

def acPlutoGatewayName = "acSensorsGateway" // to monitor the CPPM testbench sensors
def 

CCSBuilder builder = ["autochanger-standalone"]

builder.
    main ( CPPMTestBenchMainModule,
    bridge:ref("tcpProxy"),
    plutoGatewayName:acPlutoGatewayName,
    inclinometerXminus:ref("inclinometerXminus"),
    inclinometerXplus:ref("inclinometerXplus"),
    onlineClampXminus:ref("onlineClampXminus"),
    latchXminus:ref("latchXminus"),
    latchXplus:ref("latchXminus"),
    autochangerTrucks:ref("trucks")) {
    
    // tcp Proxy
    tcpProxy (CanOpenProxy, portNumber:50000, fieldBusTimeout:2000,
        clientName:"TestBench", hardwareBootTimeout:5000) {
        
        // can open devices
        "$acPlutoGatewayName" (CanOpenPlutoGateway, 
            nodeID:"3a", serialNB:"2071",station_addr:"01")
        
        latchXminusController (CanOpenEPOS24,  //CanOpenEPOS24-3
            nodeID:"3b",serialNB:"84004711",
            paramsForCurrent: [
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )
        
        latchXplusController (CanOpenEPOS24,  //CanOpenEPOS24-3
            nodeID:"3c",serialNB:"ffff",
            paramsForCurrent: [
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )
                                    
        // can open devices
        linearRailMasterController (CanOpenEPOS70, 
            nodeID:"2a", serialNB:"80001881", 
            paramsForCurrent: [
                MotorType:10, PositionSensorType:260,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition: 
            [ProfileAcceleration:1207,
                ProfileDeceleration:1207,
                MaxProfileVelocity:322,
                QuickStopDeceleration:1207,
                MaxFollowingError:200000,//on verra plus tard
                ProfileVelocity:281,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )

        // can open devices
        linearRailSlaveController (CanOpenEPOS70, 
            nodeID:"2c", serialNB:"80001932",
            paramsForCurrent: [
                MotorType:10, PositionSensorType:1,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition: 
            [ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:30000,
                MaxFollowingError:7000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]
        )
        
        // can open devices
        onlineClampXminusController (CanOpenEPOS24, 
            nodeID:"3a", serialNB:"79011616",
            paramsForCurrent: 
            [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:419, //160?
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition: 
            [ProfileAcceleration:10000,
                ProfileDeceleration:10000,
                ProfileVelocity:1000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:
            [HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0
            ],
        )
    }

    inclinometer (InclinometerModule, plutoGatewayName:plutoGatewayName)
    
    onlineClampXminus (AutochangerOnlineClampModule ,
        controller:ref("onlineClampXminusController"),
        lockSensor:ref("lockSensorClampXminus"),
        lockSensorC:ref("lockSensorCClampXminus"),
        unlockSensor:ref("unlockSensorClampXminus"),
        unlockSensorC:ref("unlockSensorCClampXminus"),
        paramsForCurrentToLock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],
        paramsForCurrentToUnlock:[ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930]
    ) {

        lockSensorClampXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:0, byteNumero:3)

        lockSensorCClampXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:1, byteNumero:3)
        
        unlockSensorClampXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:2, byteNumero:3)

        unlockSensorCClampXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:3, byteNumero:3)

        }
            
    latchXminus (AutochangerLatchModule,
        latchController:ref("latchXminusController"),
        lockSensor:ref("lockSensorLatchXminus"),
        lockSensorB:ref("lockSensorBLatchXminus"),
        unlockSensor:ref("unlockSensorLatchXminus"),
        unlockSensorB:ref("unlockSensorBLatchXminus"),
        filterPresenceSensor:ref("filterPresenceSensorLatchXminus"),
        filterPresenceSensorB:ref("filterPresenceSensorBLatchXminus")) {
        
        lockSensorLatchXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:1, byteNumero:2)

        lockSensorBLatchXminus ( CanOpenNumericSensor, //WARN : Check inputNumero
            dioName:plutoGatewayName, inputNumero:1, byteNumero:2)
        
        unlockSensorLatchXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:2, byteNumero:2)
        
        unlockSensorBLatchXminus ( CanOpenNumericSensor, //WARN : Check inputNumero
            dioName:plutoGatewayName, inputNumero:2, byteNumero:2)
        
        filterPresenceSensorLatchXminus ( CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:3, byteNumero:2)
        
        filterPresenceSensorBLatchXminus ( CanOpenNumericSensor, //WARN : Check inputNumero
            dioName:plutoGatewayName, inputNumero:3, byteNumero:2)
        }

    trucks (AutochangerTruckModule, 
        handoffPositionSensor:ref("handoffPositionSensor0"),
        handoffPositionSensorB:ref("handoffPositionSensor1"),
        onlinePositionSensor:ref("onlinePositionSensor0"),
        onlinePositionSensorB:ref("onlinePositionSensor1"),
        standbyPositionSensor:ref("standbyPositionSensor0"),
        standbyPositionSensorB:ref("standbyPositionSensor1"),
    ) {
        
        handoffPositionSensor0 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:0, byteNumero:1 )

        handoffPositionSensor1 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:1, byteNumero:1)
        
        onlinePositionSensor0 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:2, byteNumero:1 )
        
        onlinePositionSensor1 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:3, byteNumero:1 )
        
        standbyPositionSensor0 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:4, byteNumero:1 )
        
        standbyPositionSensor1 ( CanOpenNumericSensor ,
            dioName:plutoGatewayName, inputNumero:5, byteNumero:1 )                                      
    }

}