/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.NumericSensor;

/**
 * A simulated truck used by the simulated hardware control software.
 * This is used only for single-filter-test simulation.
 *
 * @author virieux
 */
public class SimuTruckModule extends TruckModule {

    /**
     * Build a new SimuTruckModule
     * @param railSensorStandback
     * @param railSensorStandby 
     */
    public SimuTruckModule(NumericSensor railSensorStandback, NumericSensor railSensorStandby) {
        super(railSensorStandback, railSensorStandby);
    }

    /**
     * In the single filter test, the simultated presence filter sensor listens
     * to the simulated truck so we have to notify our observers.
     *
     * @param hex
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Override
    public synchronized void updateLocation(String hex)  {
        super.updateLocation(hex);
        setChanged();
        this.notifyObservers(new ValueUpdate(getName(), getTruckLocation()));
    }


}
