/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.description.ComponentLookup;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;

/**
 *
 * A simulated actuator for the latch used in single-filter-test.
 * This is used only for single-filter-test simulation.
 * 
 * @author virieux
 */
public class SimuLatchActuatorModule extends LatchActuatorModule {

    private SimuCompactIOModule simuDIO;

    //for initModule
    private final String filterSensorsDIOName;

    /**
     * Build a new SimuLatchActuatorModule
     * @param currentLimitInVolt
     * @param speedVoltageInVolt
     * @param speedVoltageMinValue
     * @param speedVoltageMaxValue
     * @param filterSensorsDIOName 
     */
    public SimuLatchActuatorModule(
            double currentLimitInVolt,
            double speedVoltageInVolt,
            int speedVoltageMinValue,
            int speedVoltageMaxValue,
            String filterSensorsDIOName) {
        super(currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    @Override
    public void initModule() {
        this.simuDIO = (SimuCompactIOModule) getComponentLookup().getComponentByName(filterSensorsDIOName);
    }

    /**
     * For the simulated Latch Actuator the command open has to update the value
     * of the lock and unlock sensors on the same side of the filter (Xminus or
     * Xplus).
     *
     * @return
     * @throws FailedCommandException
     */
    @Override
    public String open() {

        ComponentLookup lookup = getComponentLookup();
        int lockSensorInputNumero;
        int unlockSensorInputNumero;
        if (getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("unlockSensorLatchXminus")).getInputNumero();
        } else if (getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new FailedCommandException(getName() + " Can't retrieve the latch for which I work.");
        }

        //For the simulated Actuator, the command open updates the value of the lock and unlock sensors.
        simuDIO.replaceDigitalValues(lockSensorInputNumero, "0", unlockSensorInputNumero, "1");
        FCSLOG.debug(getName() + " is OPEN");
        return getName() + " is OPEN";
    }

    /**
     * For the simulated latch actuator, the command close has just to update
     * the values of the lock and unlock simulated sensors.
     *
     * @return
     * @throws FailedCommandException
     */
    @Override
    public String close()  {

        ComponentLookup lookup = getComponentLookup();
        int lockSensorInputNumero;
        int unlockSensorInputNumero;
        if (getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("lockSensorLatchXminus")).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("unlockSensorLatchXminus")).getInputNumero();
        } else if (getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("lockSensorLatchXplus")).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor) lookup.getComponentByName("unlockSensorLatchXplus")).getInputNumero();
        } else {
            throw new FailedCommandException(getName() + " Can't retrieve the latch for which I work.");
        }

        //For the simulated Actuator, the command close updates the value of the lock and unlock sensors.
        simuDIO.replaceDigitalValues(lockSensorInputNumero, "1", unlockSensorInputNumero, "0");
        return getName() + " is CLOSED";
    }

    @Override
    public String powerOff() {
        return getName() + " is OFF";
    }

}
