/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 * Used only in single-filter-test simulation to simulate the devices through we read latches sensors.
 * @author virieux
 */
public class SimuCompactIOModule extends CompactIOModule {

    @ConfigurationParameter
    private String initialHexaValue;
    private NumericSensor filterPresenceSensorLatchXminus;
    private NumericSensor filterPresenceSensorLatchXplus;

    /**
     * Build a new SimuCompactIOModule
     * @param nodeID
     * @param serialNB
     * @param initialHexaValue 
     */
    public SimuCompactIOModule( 
            String nodeID, 
            String serialNB,
            String initialHexaValue) {
        super(nodeID, serialNB);
        this.initialHexaValue = initialHexaValue;
    }
    
    

    public String getInitialHexaValue() {
        return initialHexaValue;
    }

    public void setInitialHexaValue(String initialHexaValue) {
        this.initialHexaValue = initialHexaValue;
    }

    public void setHexaValue(String hex) {
        this.hexaValue = hex;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValue = this.initialHexaValue;
        ComponentLookup lookup = getComponentLookup();
        this.filterPresenceSensorLatchXminus = (NumericSensor) lookup.getComponentByName("filterPresenceSensorLatchXminus");
        this.filterPresenceSensorLatchXplus = (NumericSensor) lookup.getComponentByName("filterPresenceSensorLatchXplus");

    }

    @Override
    public String readNewHexaValue() {
        return this.hexaValue;
    }
    

    /**
     * This method updates the 2 filter presence simulated digital sensors (one
     * on each side of the filter).
     *
     * @param aDigitalValue has to be "0" or "1"
     */
    public void simulateFilterPresenceInLatches(String aDigitalValue) {

        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();

        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    /**
     * This method replace the values of 2 channels in hexaValue with the
     * digital values given as argument. The value for channel1 is replaced by
     * digitalValue1. The value for channel2 is replaced by digitalValue2. This
     * is useful when we want to simulate a new value sent by the sensors.
     * @param channel1
     * @param digitalValue1
     * @param channel2
     * @param digitalValue2
     */
    public void replaceDigitalValues(int channel1, String digitalValue1, int channel2, String digitalValue2) {
        if (channel1 < 0 || channel1 > 7) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 0 || channel2 > 7) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (!digitalValue1.equals("0") && !digitalValue1.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (!digitalValue2.equals("0") && !digitalValue2.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }

        FCSLOG.debug(getName() + "=> old hexa value = " + this.hexaValue);
        StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValue));
        bin.replace(7 - channel1, 7 - channel1 + 1, digitalValue1);
        bin.replace(7 - channel2, 7 - channel2 + 1, digitalValue2);
        String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
        FCSLOG.debug(getName() + "=> new hexa value =" + newDIOHexaValue);
        this.hexaValue = newDIOHexaValue;
    }

}
