/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is for the Single Filter Test carousel. 
 * The carousel in Single Filter Test has only one socket and doesn't rotate.
 *
 * @author virieux
 */
public class SftCarouselModule extends CarouselModule {
    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSocketByName("socket1");
    }

    @Override
    public int getPosition() {
        return 0;
    }
    
    /**
     * Executed during Initialization phase by the framework.
     * @return
     * @throws HardwareException 
     */
    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        try {
            this.ai814.initializeAndCheckHardware();
            return TreeWalkerDiag.GO;
        } catch (FcsHardwareException ex) {
            throw new HardwareException(true,ex);
        }
    }





    @Override
    public boolean isAbleToMove() {
        return false;
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    /**
     * Carousel can't rotate in single-filter-test
     * @param angle
     * @return 
     */
    public String rotate(float angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    /**
     * No brake in single-filter-test carousel.
     * @return 
     */
    @Override
    public String engageBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    /**
     * No brake in single-filter-test carousel.
     * @return 
     */
    @Override
    public String releaseBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

}
