
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;

/**
 * This represents a model for the pluto GAteway used in loader-standalone subsystem.
 * In loader-standalone there is a fakeAutochanger : an electric switch which can be switched ON and OFF.
 * This simulates that the filter in the loader (if there is one) is held by the autochanger.
 * This is used to test the opening or closing of the clamp in the same way that for the loader when it's 
 * attached to the camera.
 * 
 * The value of the switch is given by a numeric sensor (value 0 or 1) : autochangerHoldingFilterSensor
 * that we have in the loader-standalone.
 * 
 * The simulation of the loader-standalone have to simulate that the fakeAutochnager holds or not the filter.
 * This is the goal of the class SimuLoaderStandalonePlutoGateway.
 * 
 * @author virieux
 */
public class SimuLoaderStandalonePlutoGateway extends SimuLoaderPlutoGateway {
    
    private CanOpenNumericSensor autochangerHoldingFilterSensor;

    public SimuLoaderStandalonePlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        this.autochangerHoldingFilterSensor = (CanOpenNumericSensor) 
                getComponentLookup().getComponentByName("autochangerHoldingFilterSensor");
        simulateAutochangerIsNotHoldingFilter();
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "0");
    }

}
