/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;
import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;

/**
 * This class is for the simulation of a pluto gateway for the loader.
 * @author virieux
 */
public class SimuLoaderPlutoGateway extends SimuPlutoGateway {

    private LoaderCarrierModule carrier;
    private SimuLoaderCarrierController carrierController;
    private CanOpenNumericSensor lockSensor1;
    private CanOpenNumericSensor unlockSensor1;
    private CanOpenNumericSensor lockSensor2;
    private CanOpenNumericSensor unlockSensor2;
    private CanOpenNumericSensor lockSensor3;
    private CanOpenNumericSensor unlockSensor3;
    private CanOpenNumericSensor lockSensor4;
    private CanOpenNumericSensor unlockSensor4;
    private CanOpenNumericSensor loaderOnCameraSensor0;
    private CanOpenNumericSensor loaderOnCameraSensor1;
    private CanOpenNumericSensor filterPresenceSensor0;
    private CanOpenNumericSensor filterPresenceSensor1;
    private CanOpenNumericSensor storagePositionSensor0;
    private CanOpenNumericSensor handoffPositionSensor0;
    private CanOpenNumericSensor storagePositionSensor1;
    private CanOpenNumericSensor handoffPositionSensor1;
    
    

    /**
     * Build a new SimuLoaderPlutoGateway
     * @param nodeID
     * @param serialNB 
     */
    public SimuLoaderPlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getComponentLookup();
        this.lockSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderLockSensor1");
        this.lockSensor2 = (CanOpenNumericSensor) lookup.getComponentByName("loaderLockSensor2");
        this.lockSensor3 = (CanOpenNumericSensor) lookup.getComponentByName("loaderLockSensor3");
        this.lockSensor4 = (CanOpenNumericSensor) lookup.getComponentByName("loaderLockSensor4");
        this.unlockSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderUnlockSensor1");
        this.unlockSensor2 = (CanOpenNumericSensor) lookup.getComponentByName("loaderUnlockSensor2");
        this.unlockSensor3 = (CanOpenNumericSensor) lookup.getComponentByName("loaderUnlockSensor3");
        this.unlockSensor4 = (CanOpenNumericSensor) lookup.getComponentByName("loaderUnlockSensor4");
        this.loaderOnCameraSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("loaderOnCameraSensor0");
        this.loaderOnCameraSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderOnCameraSensor1");
        this.filterPresenceSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("loaderFilterPresenceSensor0");
        this.filterPresenceSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderFilterPresenceSensor1");
        this.storagePositionSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("loaderStoragePositionSensor0");
        this.storagePositionSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderStoragePositionSensor1");
        this.handoffPositionSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("loaderHandoffPositionSensor0");
        this.handoffPositionSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderHandoffPositionSensor1");
        this.carrierController = (SimuLoaderCarrierController) lookup.getComponentByName("carrierController");
        this.carrier = (LoaderCarrierModule) lookup.getComponentByName("carrier");
        
        
        
        //Filter is locked and carrier is at storage position
        simulateLoaderClampIsLocked();
        simulateLoaderIsConnectedOnCamera();
        
        simulateFilterIsOnLoader();
        simulateLoaderCarrierIsAtStorage();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsLocked() {
        simulateHookIsLocked(lockSensor1, unlockSensor1);
        simulateHookIsLocked(lockSensor2, unlockSensor2);
        simulateHookIsLocked(lockSensor3, unlockSensor3);
        simulateHookIsLocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsUnLocked() {
        simulateHookIsUnlocked(lockSensor1, unlockSensor1);
        simulateHookIsUnlocked(lockSensor2, unlockSensor2);
        simulateHookIsUnlocked(lockSensor3, unlockSensor3);
        simulateHookIsUnlocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsInTravel() {
        simulateHookIsInTravel(lockSensor1, unlockSensor1);
        simulateHookIsInTravel(lockSensor2, unlockSensor2);
        simulateHookIsInTravel(lockSensor3, unlockSensor3);
        simulateHookIsInTravel(lockSensor4, unlockSensor4);
    }
 
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateClampIsInError() {
        simulateHookIsUnlocked(lockSensor1, unlockSensor1);
        simulateHookIsUnlocked(lockSensor2, unlockSensor2);
        simulateHookIsUnlocked(lockSensor3, unlockSensor3);
        simulateHookIsLocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsLocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "1");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsUnlocked(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsInTravel(CanOpenNumericSensor lockSensor, CanOpenNumericSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "1");
        replaceDigitalValues(loaderOnCameraSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "0");
        replaceDigitalValues(loaderOnCameraSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "1");
        replaceDigitalValues(filterPresenceSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsNotOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "0");
        replaceDigitalValues(filterPresenceSensor1, "0");
    }


    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtStorage() {
        replaceDigitalValues(storagePositionSensor0, "1");
        replaceDigitalValues(storagePositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        carrierController.setPosition(carrier.getStoragePosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtHandoff() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        carrierController.setPosition(carrier.getHandoffPosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsInTravel() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
    }
}
