/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.LoaderClampModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

/**
 * This class is to simulate an EPOS Controller which controls the loader hooks.
 *
 * @author virieux
 */
public class SimuLoaderClampController extends SimuEPOSControllerModule {

    private LoaderClampModule clamp;
    private SimuLoaderPlutoGateway plutoGateway;
    private final String plutoGatewayName;

    /**
     * Build a new SimuLoaderClampController
     * @param nodeID
     * @param serialNB
     * @param plutoGatewayName
     * @param paramsForCurrent
     * @param paramsForProfilePosition
     * @param paramsForHoming 
     */
    public SimuLoaderClampController(
            String nodeID, String serialNB,
            String plutoGatewayName,
            Map<String, Integer> paramsForCurrent,
            Map<String, Integer> paramsForProfilePosition,
            Map<String, Integer> paramsForHoming
    ) {
        super(nodeID, serialNB, 
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGatewayName = plutoGatewayName;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getComponentLookup();
        clamp = (LoaderClampModule) lookup.getComponentByName("clamp");
        plutoGateway = (SimuLoaderPlutoGateway) lookup.getComponentByName(plutoGatewayName);
    }

    @Override
    public void writeCurrent(int aValue)  {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSLOG.debug("=>initial current=" + actualCurrent);
        int stepsNB = 10;
        int step = (targetCurrent - this.actualCurrent) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {

            this.actualCurrent = currentInitial + (i * step);
            clamp.updateCurrent();
            if (actualCurrent == clamp.getCurrentToClamp()) {
                FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                this.position = clamp.getTargetPositionToClamp();
                this.plutoGateway.simulateLoaderClampIsLocked();

            } else if (actualCurrent == clamp.getCurrentToGoHome()) {
                this.position = clamp.getTargetPositionToOpen();
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            }
            clamp.publishData();
            FCSLOG.debug("i=" + i + ",actualCurrent=" + actualCurrent);
            try {
                Thread.sleep(500);
                if (clamp.getHaltRequired().get()) {
                    FCSLOG.debug(getName() + " STOP simulated clamp motion.");
                    return;
                }
            } catch (InterruptedException ex) {
                throw new FcsHardwareException(getName() + " sleep was interrupted.", ex);
            }

        }
        this.actualCurrent = aValue;
        if (actualCurrent == clamp.getCurrentToClamp()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.position = clamp.getTargetPositionToClamp();
            this.plutoGateway.simulateLoaderClampIsLocked();

        } else if (actualCurrent == clamp.getCurrentToGoHome()) {
            this.position = clamp.getTargetPositionToOpen();
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        }
        clamp.publishData();
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.debug("=>position intitiale=" + position);
        int stepsNB = 10;
        int step = (targetPosition - this.position) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {

            this.position = positionInitiale + (i * step);
            clamp.updatePosition();
            if (position == clamp.getTargetPositionToOpen()) {
                FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                this.plutoGateway.simulateLoaderClampIsUnLocked();
            } else if (position == clamp.getTargetPositionToClose() ||
                    position == clamp.getTargetPositionToClamp()) {
                this.plutoGateway.simulateLoaderClampIsLocked();
            } else {
                this.plutoGateway.simulateLoaderClampIsInTravel();
            }
            clamp.publishData();
            FCSLOG.debug("i=" + i + ",position=" + position);
            try {
                Thread.sleep(500);
            } catch (InterruptedException ex) {
                throw new RejectedCommandException(getName() + " sleep was interrupted.");
            }

        }
        this.position = targetPosition;
        if (position == clamp.getTargetPositionToOpen()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.plutoGateway.simulateLoaderClampIsUnLocked();
        } else if (position == clamp.getTargetPositionToClose()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else if (position == clamp.getTargetPositionToClamp()) {
            this.plutoGateway.simulateLoaderClampIsLocked();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();
        }
        clamp.publishData();
    }
}
