/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.description.ComponentLookup;

import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

/**
 *
 * @author virieux
 */
public class SimuLoaderCarrierController extends SimuEPOSControllerModule {

    private LoaderCarrierModule carrier;
    private LoaderModule loader;
    private SimuLoaderPlutoGateway plutoGateway;
    private final String plutoGatewayName;

    /**
     * Build a new SimuLoaderCarrierController
     * @param nodeID
     * @param serialNB
     * @param plutoGatewayName
     * @param paramsForCurrent
     * @param paramsForProfilePosition
     * @param paramsForHoming 
     */
    public SimuLoaderCarrierController(
            String nodeID, String serialNB,
            String plutoGatewayName,
            Map<String, Integer> paramsForCurrent,
            Map<String, Integer> paramsForProfilePosition,
            Map<String, Integer> paramsForHoming
    ) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.plutoGatewayName = plutoGatewayName;
    }

    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getComponentLookup();
        carrier = (LoaderCarrierModule) lookup.getComponentByName("carrier");
        loader = (LoaderModule) lookup.getComponentByName("loader");
        plutoGateway = (SimuLoaderPlutoGateway) lookup.getComponentByName(plutoGatewayName);
    }

    /**
     * 
     * @param positionToReached
     * @throws SDORequestException 
     */
    @Override
    public void writeTargetPosition(int positionToReached)  {
        
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.debug("loader carrier is moving.");
        FCSLOG.debug(getName() + "=>position intitiale=" + position);
        int stepsNB = 20;
        int step = (targetPosition - this.position) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {
            try {

                this.position = positionInitiale + (i * step);
                carrier.updatePosition();
                if (position == carrier.getHandoffPosition()) {
                    FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (position == carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                loader.updateStateWithSensors();
                carrier.publishData();
                FCSLOG.debug(getName() + "i=" + i + ",position=" + position);
                try {
                    Thread.sleep(500);
                    if (carrier.getHaltRequired().get()) {
                        FCSLOG.debug(getName() + " STOP simulated carrrier motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new RejectedCommandException(getName() + " sleep was interrupted.");
                }

            } catch (FcsHardwareException ex) {
                FCSLOG.error(ex);
                throw new RejectedCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == carrier.getHandoffPosition()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (position == carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }

    }


}
