/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.TreeWalkerDiag;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenNode;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

/**
 *
 * @author virieux
 */
public class SimuCanOpenProxy extends CanOpenProxy {

    public SimuCanOpenProxy(int portNumber, int fieldBusTimeout, String clientName,
            long hardwareBootTimeout) {
        super(portNumber, fieldBusTimeout, clientName, hardwareBootTimeout);
    }
    

    @Override
    public void initModule() {
        super.initModule();
        this.hardwareBootProcessEnded = true;
    }

    @Override
    public void startServer() {
        tcpServerStarted = true;
        stopped = false;
    }

    @Override
    public void startThreadReader() {
    }

    @Override
    public void stopServer() {
        stopped = true;
        tcpServerStarted = false;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws org.lsst.ccs.HardwareException {
        FCSLOG.debug(getName() + ": BEGIN CHECKHARDWARE");
        this.getSubsystem().updateAgentState(FcsEnumerations.FilterState.HOMING_TO_BE_DONE, 
                FcsEnumerations.FilterReadinessState.NOT_READY);
        //Creation of the bootedNodes map.
        for (PieceOfHardware device : hardwareMapByNodeID.values()) {
            bootedNodes.put(device.getNodeID(), new CanOpenNode(device.getNodeID(),device.getSerialNB()));
            publishHardwareData(device);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }
   
    @Override
    public PDOStorage readPDOs()  {
        FCSLOG.debug(getName() + "/readPDOS");
        return this.getPdoStorage();
    }
    
    @Override
    public boolean isCANDevicesReady() {
        return true;
    }
    
    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }

}
