
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.CanOpenNumericSensor;

/**
 * In the autochanger-standalone subsystem, there are 2 electric switchs to simulate that 
 * carousel is holding a filter at STANDBY or loader is holding a filter at HANDOFF.
 * 
 * This switchs are connected to sensors which sends value 0 when not holding filter or 1 when holding filter.
 * 
 * For FCS with real hardware this sensors are read like the other sensors from the plutoGateway.
 * For FCS with simulated hardware we have to add these sensors in plutoGateway to be able to simulate 
 * founctionalities of the switches (isHolding filter or not).
 *
 * @author virieux
 */
public class SimuAutochangerStandalonePlutoGateway extends SimuAutochangerPlutoGateway {
    
    private CanOpenNumericSensor carouselHoldingFilterSensor0;
    private CanOpenNumericSensor carouselHoldingFilterSensor1;
    
    private CanOpenNumericSensor loaderHoldingFilterSensor0;
    private CanOpenNumericSensor loaderHoldingFilterSensor1;

    /**
     * 
     * @param nodeID
     * @param serialNB 
     */
    public SimuAutochangerStandalonePlutoGateway(String nodeID, String serialNB) {
        super(nodeID, serialNB);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getComponentLookup();
        this.carouselHoldingFilterSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("carouselHoldingFilterSensor0");
        this.carouselHoldingFilterSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("carouselHoldingFilterSensor1");
        simulateCarouselIsNotHoldingFilter();
        this.loaderHoldingFilterSensor0 = (CanOpenNumericSensor) lookup.getComponentByName("loaderHoldingFilterSensor0");
        this.loaderHoldingFilterSensor1 = (CanOpenNumericSensor) lookup.getComponentByName("loaderHoldingFilterSensor1");
        simulateLoaderIsNotHoldingFilter();
    }

    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateCarouselIsHoldingFilter() {
        replaceDigitalValues(carouselHoldingFilterSensor0, "1");
        replaceDigitalValues(carouselHoldingFilterSensor1, "0");
        /* carousel and loader can't both hold filter*/
        simulateLoaderIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateCarouselIsNotHoldingFilter() {
        replaceDigitalValues(carouselHoldingFilterSensor0, "0");
        replaceDigitalValues(carouselHoldingFilterSensor1, "1");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsHoldingFilter() {
        this.simulateLoaderIsConnected();
        replaceDigitalValues(loaderHoldingFilterSensor0, "1");
        replaceDigitalValues(loaderHoldingFilterSensor1, "0");
        /* carousel and loader can't both hold filter*/
        simulateCarouselIsNotHoldingFilter();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsNotHoldingFilter() {
        replaceDigitalValues(loaderHoldingFilterSensor0, "0");
        replaceDigitalValues(loaderHoldingFilterSensor1, "1");
    }

}
