/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;

/**
 * To simulate a controller which opens and closes a ONLINE clamp on the autochanger.
 * @author virieux
 */
public class SimuAutochangerOnlineClampController extends SimuEPOSControllerModule {
    
    @ConfigurationParameter(isFinal = true)
    private String onlineClampName;
    
    private SimuAutochangerPlutoGateway plutoGateway;
    private String plutoGatewayName;
    
    private AutochangerOnlineClampModule onlineClamp;
    


    /**
     * Build a new SimuAutochangerOnlineClampController.
     * @param nodeID
     * @param serialNB
     * @param onlineClampName
     * @param paramsForCurrent
     * @param paramsForProfilePosition
     * @param paramsForHoming 
     */
    public SimuAutochangerOnlineClampController(
            String nodeID, String serialNB,
            String onlineClampName,
            Map<String, Integer> paramsForCurrent,
            Map<String, Integer> paramsForProfilePosition,
            Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB,
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.onlineClampName = onlineClampName;
        this.plutoGatewayName = "acPlutoGateway";
    }
    
    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getComponentLookup();
        this.plutoGateway = (SimuAutochangerPlutoGateway) lookup.getComponentByName(plutoGatewayName);
        this.onlineClamp = (AutochangerOnlineClampModule) lookup.getComponentByName(onlineClampName);
    }
    
    /**
     * Quick and dirty simulation.
     * This will have to be refactorized after tests on the real hardware.
     * 
     * @param current 
     */
    @Override
    public void writeCurrent(int current) {
        this.targetCurrent = current;
        this.actualCurrent = current;
        if (targetCurrent == onlineClamp.getCurrentToClose()) {

            plutoGateway.simulateAutochangerOnlineClampsAreLocked();
            
        } else if(targetCurrent == onlineClamp.getCurrentToOpen()) {

            plutoGateway.simulateAutochangerOnlineClampsAreUnlocked();
        }
    }
    


}
