/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * The autochanger module for the whole Filter Exchange System or the fake autochanger module 
 * implements this interface.
 * In the case of the whole Filter Exchange System, when there is a carousel, an
 * autochanger and a loader, the sensors of the autochanger latches tell us if
 * the filter is held by autochanger or not.
 * When carousel or loader are in standalone mode, there is no autochanger hardware.
 * But sometimes we want to test that the hardware as if the autochanger was holding 
 * a filter. This is done usualy with a numeric switch and a sensor that can be read 
 * to know the value of the switch. 
 * 
 * @author virieux
 */
public interface FilterHolder {
    
    /**
     * This method returns true if the FilterHolder  is holding a filter, false otherwise.
     * @return 
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException 
     */
    boolean isHoldingFilter();
    
    /**
     * This method returns true if the autochanger trucks are at HANDOFF position, false otherwise.
     * @return 
     */
    boolean isAtHandoff();
    
    /**
     * This method returns true if the autochanger trucks are at STANDBY position, false otherwise.
     * @return 
     */
    boolean isAtStandby();
    
    
    /**
     * This method read values sent by the sensors and update state from this new values.
     * @throws FcsHardwareException 
     */
    void updateStateWithSensors();


    
}
