/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.framework.TreeWalkerDiag;

/**
 * This interface has to be implemented by classes which start a tcpip server
 * to communicate with real hardware or by classes which simulate the communication
 * with hardware.
 * 
 * @author virieux
 */
public interface BridgeToHardware {

    
    TreeWalkerDiag checkHardware() throws HardwareException;

    /**
     * This method is used when the loader CANbus is connected.
     * @throws HardwareException 
     */
    void connectHardware() throws HardwareException;

    /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    void disconnectHardware();

    /**
     * Return a String with the list of hardware expected in this subsystem.
     * For debug purpose.
     * @return
     */
    String printHardwareList();
    
    /**
     * Return an Array containing hardware names handled by this component.
     * @return
     */
    List<String> listHardwareNames();
    
    /**
     * Return a printed list of hardware with the initialization state.
     * For debug purpose.
     * @return 
     */
    String printHardwareState();
    
    /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    void publishData();
    
    /**
     * This method returns true if the C-Wrapper is connected to the tcp proxy.
     * The C-Wrapper has to send the tcpProxy clientName as a keyword before any
     * communication can begin. So if the C-Wrapper doesn't send the good
     * keyword or if it doesn't connect to the tcp proxy, this method returns
     * false.
     * @return 
     */
    boolean isCWrapperConnected();

    /**
     *
     * @return true if this bridge is connected with real hardware, false if the
     * hardware is simulated.
     */
    boolean isRealHardware();

    /**
     * @return true if the hardware is booted, identified.
     */
    boolean isCANDevicesReady();

    void startServer();

    void startThreadReader();

    PDOStorage readPDOs();
    
}
