
package org.lsst.ccs.subsystems.fcs;

/**
 * Represents a couple of sensors which are redondant : that means they must have the same digitalValue.
 * If the 2 sensors have different digital value, the couple of sensors is in error.
 * 
 * This sort of sensors are used in loader carrier.
 * The goal is to be able to detect errors in sensors (capteur défectueux, error de câblage)
 * 
 * @author virieux
 */
public class RedondantSensors {
    
    private final NumericSensor sensor;
    
    private final NumericSensor sensorR;

    public RedondantSensors(NumericSensor sensor, NumericSensor sensorR) {
        this.sensor = sensor;
        this.sensorR = sensorR;
    }

    public boolean isInError() {
        return sensor.getDigitalValue() != sensorR.getDigitalValue();
    }

     /**
     * 
     * @return true if both sensors value is 1
     */
    public boolean isOn() {
        return sensor.getDigitalValue() == 1 && sensorR.getDigitalValue() == 1;
    }
    
    /**
     * 
     * @return sensor's digital value
     */
    public int getDigitalValue() {
        return sensor.getDigitalValue();
    }
    
    /**
     * Updates sensors values from an array of hexadecimal values.
     * @param hexaValues 
     */
    public void updateValues(String[] hexaValues) {
        sensor.updateValue(hexaValues);
        sensorR.updateValue(hexaValues);
    }    
    

}
