
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;

/**
 * This class represents a numeric sensor which sends a digitalValue 0 or 1.
 * This type of sensors are used in the autochanger for the rail filter presence
 * sensor : the sensors which detects if a filter is there or not on each side
 * of the rail and at standby and standback position. This is used too to
 * monitor the autochanger latches : to know if a latch is locked or unlocked.
 *
 * @author virieux
 */
public abstract class NumericSensor extends Module {

    protected int digitalValue = 0;

    public NumericSensor() {
    }

    @Override
    public void initModule() {
        this.digitalValue = 0;
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public int getDigitalValue() {
        return this.digitalValue;
    }

    /**
     * update the digitalValue of this object with the
     *
     * @param hexaValueReadOnDevice
     */
    public abstract void updateValue(String hexaValueReadOnDevice);
    
    /**
     * returns the numero of input of the DIO device where this sensor is plugged on.
     * @return 
     */
    public abstract int getInputNumero();
    
    /**
     * This methods is used when the device sends an array of values instead of one value.
     * @param hexaValues 
     */
    public abstract void updateValue(String[] hexaValues);

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "Returns the value of the sensor stored in memory.",
            alias="printValue")
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/value=");
        sb.append(this.digitalValue);
        return sb.toString();
    }

    public int getByteNumero() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }



    

}
