
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;

/**
 * Represents a couple of NumericSensor which are complementary :
 * when one has the value 1 the other must have value 0 and vice versa.
 * If both sensors have the same value, the couple of sensors is in error.
 * 
 * This sort of sensors are used in autochanger. 
 * The goal is to be able to detect errors in sensors (capteur défectueux, error de câblage)
 * 
 * @author virieux
 */
public class ComplementarySensors extends Module implements AlertRaiser {
    
    private final NumericSensor sensor;
    
    private final NumericSensor sensorC;

    /**
     * Create a couple of complementary sensors.
     * @param sensor 
     * @param sensorC 
     */
    public ComplementarySensors(NumericSensor sensor, NumericSensor sensorC) {
        this.sensor = sensor;
        this.sensorC = sensorC;
    }

    /**
     * for simulation
     * @return 
     */
    public NumericSensor getSensor() {
        return sensor;
    }

    /**
     * for simulation
     * @return 
     */
    public NumericSensor getSensorC() {
        return sensorC;
    }
    
    
    
    /**
     * 
     * @return true if this couple of sensors are in error.
     */
    public boolean isInError() {
        return sensor.getDigitalValue() == sensorC.getDigitalValue();
    }
    
    /**
     * 
     * @return true if sensor's value is 1 and sensorC's value is 0
     */
    public boolean isOn() {
        return sensor.getDigitalValue() == 1 && sensorC.getDigitalValue() == 0;
    }
    
    /**
     * 
     * @return sensor's digital value
     */
    public int getDigitalValue() {
        return sensor.getDigitalValue();
    }
    
    /**
     * Updates sensors values from a 
     * @param hexaValues 
     */
    public synchronized void updateValues(String[] hexaValues) {
        sensor.updateValue(hexaValues);
        sensorC.updateValue(hexaValues);
    }
}
