/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and unlockClamps the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is the Main Module when autochanger is in standalone mode.
 *
 * @author virieux
 */
public class AutochangerMainModule extends MainModule {

    private final AutoChangerModule autochanger;
    private final InclinometerModule inclinometer;
    //TODO add another inclinometer (pour la redondance)
    //si on lit la même valeur sur les 2 c'est OK
    //plage de valeurs acceptables pour l'horizontalité
    //max acceptable pour la différence entre les 2 inclinometres
    private FilterHolder carousel;
    private FilterHolder loader;
    

    /**
     * Build a AutochangerMainModule.
     * @param bridge
     * @param autochanger
     * @param inclinometer 
     */
    public AutochangerMainModule(
            BridgeToHardware bridge,
            AutoChangerModule autochanger,
            InclinometerModule inclinometer) {
        super(bridge);
        this.autochanger = autochanger;
        this.inclinometer = inclinometer;
    }
    
    @Override
    public void initModule() {
        super.initModule();
        ComponentLookup lookup = getSubsystem().getComponentLookup();
        this.carousel = (FilterHolder) lookup.getComponentByName("carousel");
        this.loader = (FilterHolder) lookup.getComponentByName("loader");
    }

    /**
     * Update inclinaison value in reading the inclinometer, and returns the new value.
     * @return
     * @throws FcsHardwareException 
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update inclinaison value in reading the inclinometer,"
                    + "and returns the new value.")
    public double readInclinaison()  {
        return inclinometer.readInclinaison();
    }

    /**
     * Update autochanger state in reading the sensors.
     * @throws FcsHardwareException 
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update autochanger state in reading the sensors.")
    @Override
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        autochanger.updateStateWithSensors();
        carousel.updateStateWithSensors();
        loader.updateStateWithSensors();
    }

    /**
     * Check that Autochanger hardware is ready to be operated and moved.
     * This means that :
     * - all CAN open devices are booted, identified and initialized,
     * - homing has been done on the controllers.
     * This updates the FCS state and FCS readyness state and publishes on the status bus.
     * 
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1, 
            description = "Update FCS state and FCS readyness state and publishes on the status bus.")
    @Override
    public void updateFCSState() {
        if (autochanger.isInitialized()) {
            /* The initialization has been done, so now the hardware is ready */
            this.getSubsystem().updateAgentState(FcsEnumerations.FilterState.HARDWARE_READY, 
                FcsEnumerations.FilterReadinessState.READY);
        }
    }

}
