package loader

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder



//********************************************************************************//
//Loader variables
//********************************************************************************//
def loaderTcpProxyName = "loaderTcpProxy"
def loaderPlutoGatewayName = "loaderPlutoGateway" // to monitor the loader sensors
//********************************************************************************//

CCSBuilder builder = ["loader-standalone"]

builder.
    main( LoaderMainModule,bridge:ref("$loaderTcpProxyName")) {
    //begin description of Main submodules
    // Loader tcp Proxy
    //loaderTcpProxy (LoaderCanOpenProxy,
    "$loaderTcpProxyName" (SimuCanOpenProxy, //works
            //loaderTcpProxyName (SimuCanOpenProxy, //DOES NOT work
            //loaderTcpProxy (SimuCanOpenProxy, //works
            portNumber:51000,fieldBusTimeout:2000,clientName:"TestBench",hardwareBootTimeout:1000) {
        hooksController (SimuLoaderClampController,
            nodeID:"1b",serialNB:"79007141",
            //plutoGatewayName",loaderPlutoGatewayName),
            plutoGatewayName:"$loaderPlutoGatewayName",
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition:[
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]) 
        
        carrierController (SimuLoaderCarrierController,
            nodeID:"1a",serialNB:"80003184",
            //plutoGatewayName",loaderPlutoGatewayName),
            plutoGatewayName:"$loaderPlutoGatewayName",
            paramsForCurrent:[
                ContinuousCurrentLimit:7290,
                OutputCurrentLimit:14580,
                MaxSpeedInCurrentMode:9840,
                MotorType:10,
                PositionSensorType:4,
                ThermalTimeConstantWinding:187,
                PolePairNumber:1],
            paramsForProfilePosition:[
                MinPositionLimit:-250,
                MaxPositionLimit:1037700,
                MotionProfileType:0,
                MaxFollowingError:6000,
                MaxProfileVelocity:227, 
                ProfileVelocity:120,
                ProfileAcceleration:100,
                ProfileDeceleration:100,
                QuickStopDeceleration:10000],
            paramsForHoming:[
                HomeOffset:0,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500])

        // description of plutoGateway
        "$loaderPlutoGatewayName" (SimuLoaderStandalonePlutoGateway, 
            nodeID:"1",serialNB:"22d6")
    }//end description of Loader bridge's children
    //----------------------------------------------
    // END Bridge To LOADER description
    //----------------------------------------------
    /**********************************************************************/
    /*                FAKE AUTOCHANGER DESCRIPTION                       */
    /**********************************************************************/
    //in the loader standalone subsystem the fake autochanger is a switch which
    //simulate that autochanger holds a filter at HANDOFF 
    
    autochanger(FakeFilterHolder,
        plutoGatewayName:loaderPlutoGatewayName,
        holdingFilterSensor:ref("autochangerHoldingFilterSensor"))
    {//begin description of fakeAutochanger's children 
        autochangerHoldingFilterSensor(CanOpenNumericSensor ,
            dioName:loaderPlutoGatewayName,inputNumero: 5,byteNumero: 5)
    }//end description of fakeAutochanger's children
    
    /**********************************************************************/
    /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
    /**********************************************************************/

    //begin description of loader
    loader (LoaderModule,
        carrier:ref("carrier"),
        clamp:ref("clamp"),
        plutoGatewayName:loaderPlutoGatewayName,
        filterPresenceSensor0:ref("loaderFilterPresenceSensor0"),
        filterPresenceSensor1:ref("loaderFilterPresenceSensor1"),
        loaderOnCameraSensor0:ref("loaderOnCameraSensor0"),
        loaderOnCameraSensor1:ref("loaderOnCameraSensor1"))
    {//begin description of loader's children
        carrier(LoaderCarrierModule,
            handoffPositionSensor:ref("loaderHandoffPositionSensor0"),
            handoffPositionSensor1:ref("loaderHandoffPositionSensor1"),
            storagePositionSensor:ref("loaderStoragePositionSensor0"),
            storagePositionSensor1:ref("loaderStoragePositionSensor1"))
        {//begin description of loader carrier's children
            loaderHandoffPositionSensor0 ( CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName, inputNumero: 6, byteNumero: 1)
            loaderHandoffPositionSensor1 ( CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName, inputNumero: 7, byteNumero: 1)
            loaderStoragePositionSensor0 ( CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName, inputNumero: 4, byteNumero: 1)
            loaderStoragePositionSensor1 ( CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName,inputNumero: 5, byteNumero: 1)                                       
        }//end description of loader carrier's children
        
        clamp(LoaderClampModule,
            hook1:ref("hook1"),hook2:ref("hook2"),hook3:ref("hook3"),hook4:ref("hook4"),
            paramsForCurrentToClamp:[
                ContinuousCurrentLimit:500,
                OutputCurrentLimit:1000,
                MaxSpeedInCurrentMode:500],
            paramsForCurrentToGoHomePosition:[
                ContinuousCurrentLimit:500,
                OutputCurrentLimit:1000,
                MaxSpeedInCurrentMode:500])
        {//begin description of loader clamp's children
           int[] inputNumeroLock = [4,5,6,7];
            int[] inputNumeroUnlock = [0,1,2,3];
            for (int i = 1; i<5; i++) {
            
            "hook${i}"(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor${i}"), unlockSensor:ref("loaderUnlockSensor${i}"))
                {
                    "loaderLockSensor${i}" ( CanOpenNumericSensor , //closeHookSensor0
                        dioName:loaderPlutoGatewayName, inputNumero:inputNumeroLock[i-1], byteNumero:0)
                       
                    "loaderUnlockSensor${i}" ( CanOpenNumericSensor , //openHookSensor0
                        dioName:loaderPlutoGatewayName, inputNumero:inputNumeroUnlock[i-1], byteNumero:0)
                }
            }
            
            loaderFilterPresenceSensor0(CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName,inputNumero: 0,byteNumero: 1)
            
            loaderFilterPresenceSensor1(CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName,inputNumero: 1,byteNumero: 1)
            
            loaderOnCameraSensor0(CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName,inputNumero: 2,byteNumero: 1)
            
            loaderOnCameraSensor1(CanOpenNumericSensor ,
                dioName:loaderPlutoGatewayName,inputNumero: 3,byteNumero: 1)
        }//end description of loader's children
    }    // main
}
