package filterIdentificatorTest

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder



def acPlutoGatewayName = "acPlutoGateway" // to monitor the autochanger sensors

CCSBuilder builder = ["filterIdentificator"]

builder.
    main ( MainModule,
    bridge:ref("tcpProxy"))
{
    
    //-------------------------
    // BEGIN MainModule description
        // tcp Proxy
        tcpProxy (SimuCanOpenProxy,
            portNumber:50000,fieldBusTimeout:2000,
            clientName:"TestBench",hardwareBootTimeout:1000) {
        // can open devices
        "$acPlutoGatewayName" (SimuPlutoGatewayWithFilterID,
            nodeID:"30",serialNB:"2071")
    }
    //-------------------------
    // BEGIN Filter Identificator description
    
    filterIdentificator(FilterIdentificator,gwName:"$acPlutoGatewayName")
    {//begin description of filter Identificator's children
        filterIDSensor0 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 0,
            byteNumero: 5,
        )
        
        filterIDSensor1 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 1,
            byteNumero: 5,
        )
        
        filterIDSensor2 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 2,
            byteNumero: 5,
        )
        
        filterIDSensor3 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 3,
            byteNumero: 5,
        )
        
        filterIDSensor4 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 4,
            byteNumero: 5)
        
        
        filterIDSensor5 ( CanOpenNumericSensor ,
            
            dioName:acPlutoGatewayName,
            inputNumero: 5,
            byteNumero: 5,
        ) 
        
        
    }//end description of filter manager's children
    // END Filter Identificator description
    // ------------------------------
}//end main module