package CPPMTestBench

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder


import static org.lsst.gruth.jutils.MapArgs.*

def plutoGatewayName = "plutoGateway" // to monitor the CPPM testbench sensors

CCSBuilder builder = ["testbenchCPPM"] // to test CPPM testbench GUI

builder.
        main ( CPPMTestBenchMainModule,
                argMap(
                        ref("bridge"),
                        aString("plutoGWName",plutoGatewayName),
                        ref("inclinometer"),
                        ref("onlineClampXminus"),
                        ref("latchXminus"),
                        ref("autochangerTrucks"),
                        //ref("autochanger"),                                              
                        ))
                 


            //begin description of Main submodules
            {

                // Bridge
                bridge (SimuBridgeToCanOpenHardware,
                        argMap(
                            ref("tcpProxy"),
                            ref("plutoGateway"),
                            ref("latchController"),
                            ref("linearRailMasterController"),
                            ref("linearRailSlaveController"),
                            ref("onlineClampController"),                            
                            ))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (SimuCanOpenProxy,
                                argMap(
                                    anInt("portNumber", 50000),
                                    a("fieldBusTimeout", 2000),
                                    aString("myClientName","TestBench"),
                                    anInt("hardwareBootTimeout",1000),
                                    ))

                        // can open devices
                        plutoGateway (SimuTestbenchCPPMPlutoGateway, 
                                argMap(
                                    aString("nodeID","30"),
                                    aString("serialNB","2071"),
                                    //aString("station_addr","01"),
                        ))
                    
        
                        latchController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
                                argMap(
                                    aString("nodeID","4"),
                                    aString("serialNB","84004711"),
                                    aString("latchName","latch"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:2,
                                        ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                                        ThermalTimeConstantWinding:40,
                                        MaxSpeedInCurrentMode:100]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of latchController's children
                            }//end description of latchController's children

                        // can open devices
                        linearRailMasterController (SimuAutochangerLinearRailController, 
                                argMap(
                                    aString("nodeID","2a"),
                                    aString("serialNB","80001881"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:260,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:1207,
                                        ProfileDeceleration:1207,
                                        MaxProfileVelocity:322,
                                        QuickStopDeceleration:1207,
                                        MaxFollowingError:200000,//on verra plus tard
                                        ProfileVelocity:281,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailMasterController's children
                            }//end description of linearRailMasterController's children

                        // can open devices
                        linearRailSlaveController (SimuAutochangerLinearRailController, 
                                argMap(
                                    aString("nodeID","2b"),
                                    aString("serialNB","80001932"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:1,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:30000,
                                        MaxFollowingError:7000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailSlaveController's children
                            }//end description of linearRailSlaveController's children

                        // can open devices
                        onlineClampController (SimuAutochangerOnlineClampController, 
                                argMap(
                                    aString("nodeID","3a"),
                                    aString("serialNB","79011616"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                                        ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                                        ThermalTimeConstantWinding:160,
                                        MaxSpeedInCurrentMode:6930]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:10000,
                                        MaxFollowingError:2000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",
                                        [HomeOffset:0, MaxProfileVelocity:6930,
                                        SpeedForSwitchSearch:100,
                                        SpeedForZeroSearch:10,
                                        HomingAcceleration:1000,
                                        CurrentThresholdHomingMode:500,
                                        HomePosition:0
                                        ]),
                                    ))
                                    
                            {//begin description of linearRailSlaveController's children
                            }//end description of linearRailSlaveController's children


                            
                }//end description of bridge's children

       
               inclinometer (InclinometerModule, 
                                argMap(
                                    aString("plutoGatewayName",plutoGatewayName,
                                        [static:true,description:"The name of the pluto gateway where this inclinometer is plugged."]),
               ))

                onlineClampXminus(AutochangerOnlineClampModule ,
                    argMap(
                    aRef("controller","onlineClampController"),
                    aRef("lockSensor","lockSensorClampXminus"),
                    aRef("lockSensorC","lockSensorCClampXminus"),
                    aRef("unlockSensor","unlockSensorClampXminus"),
                    aRef("unlockSensorC","unlockSensorCClampXminus"),
                    anInt("currentToLock",300,[description:"current to lock the clamp in mA"]),
                    anInt("currentToUnlock",-300,[description:"current to unlock, in mA"]),
                    anInt("currentToClamp",3000,[description:"current to clamp, in mA"]),                                                           
                    aMap("paramsForCurrentToLock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to clamp the clamp."]),
                    aMap("paramsForCurrentToUnlock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                    anInt("holdTime",5000,[description:"time to hold clamp, in millis"]),
                    anInt("travelTime",5000,[description:"time for clamp to lock, in millis"]),                 
                ))
                    {//begin description of autochanger onlineClampXminus children

                            "lockSensorClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    a("dioName",plutoGatewayName),
                                    a("inputNumero", 0),
                                    a("byteNumero", 3)
                                ))

                            "lockSensorCClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))
                            "unlockSensorClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                            "unlockSensorCClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName,[static:true,description:"The name of the Digital Input Output device where this sensor is plugged."]),
                                    anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                    anInt("byteNumero", 3, [description:"The numero of the byte where the value of this sensor is stored."]),
                                ))

                    }//end of  description of autochanger onlineClampXminus children
            
                        //*************************************//
                        // autochanger latchXminus description
                        //*************************************//
                        latchXminus (AutochangerLatchModule,
                            argMap(
                                aRef("latchController","latchController"),
                                anInt("timeoutForClosing",3000,
                                  [description:"timeout in milliseconds."]),
                                anInt("timeoutForOpening",3000,
                                  [description:"timeout in milliseconds."]),
                                aRef("lockSensor","lockSensorLatchXminus"),
                                aRef("unlockSensor","unlockSensorLatchXminus"),
                                aRef("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                anInt("minCurrent",-300,[description:"min position value used by the GUI"]),
                                anInt("maxCurrent",300,[description:"max current value used by the GUI"]),
                                anInt("currentToOpen",200,[description:"in mA current to be sent to the controller to open the latch."]), 
                                ))
                        {//begin description of autochanger latchXminus children
                        "lockSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap(
                                aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                            ))

                        "unlockSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap( 
                                aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                            ))

                        "filterPresenceSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap( 
                                aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                                anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged."]),
                                anInt("byteNumero", 2, [description:"The numero of the byte where the value of this sensor is stored."]),
                            ))
                        }//end description of autochanger latchXminus children
                        //**********************************************//
                        // end of autochanger latchXminus description   //
                        //**********************************************//
 

                        autochangerTrucks (AutoChangerTrucksModule, 
                            argMap(
                                ref("handoffPositionSensor0"),
                                ref("handoffPositionSensor1"),
                                ref("onlinePositionSensor0"),
                                ref("onlinePositionSensor1"),
                                ref("standbyPositionSensor0"),
                                ref("standbyPositionSensor1"),
                            ))
               
                    {//begin description of autochanger trucks children

                        "handoffPositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 0, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "handoffPositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 1, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "onlinePositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 2, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "onlinePositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 3, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "standbyPositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 4, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))
                        "standbyPositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName,[static:true,description:"The name of the DIO (Digital Input Output module) where this sensor is plugged."]),
                            anInt("inputNumero", 5, [description:"The numero of the input on the filter sensors DIO where this sensor is plugged.", constraints:0..7]),
                            anInt("byteNumero", 1, [description:"The numero of the byte returned by the gateway which contains the value of this sensor.", constraints:0..7])
                            ))                                       
                    }//end description of autochanger trucks children


            }//end description of Main submodules

                


