package CPPMTestBench

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder


import static org.lsst.gruth.jutils.MapArgs.*

def plutoGatewayName = "plutoGateway" // to monitor the CPPM testbench sensors

CCSBuilder builder = ["testbenchCPPM"]

builder.
        main ( CPPMTestBenchMainModule,
                argMap(
                        ref("bridge"),
                        aString("plutoGWName",plutoGatewayName),
                        ref("inclinometer"),
                        ref("onlineClamp"),
                        ref("latchXminus"),
                        ref("trucks"),
                        ))
                 


            //begin description of Main submodules
            {

                // Bridge
                bridge (Bridge,
                        argMap(
                            ref("tcpProxy"),
                            ref("plutoGateway"),
                            ref("latchXminusController"),
                            ref("linearRailMasterController"),
                            ref("linearRailSlaveController"),
                            ref("onlineClampXminusController"),                           
                            ))

                {//begin description of bridge's children          

                        // tcp Proxy
                        tcpProxy (CanOpenProxy,
                                argMap(
                                    anInt("portNumber", 50000),
                                    a("fieldBusTimeout", 2000),
                                    aString("myClientName","TestBench"),
                                    anInt("hardwareBootTimeout",5000),
                                ))

                        // can open devices
                        plutoGateway (CanOpenPlutoGateway, 
                                argMap(
                                    aString("nodeID","30"),
                                    aString("serialNB","2071"),
                                    aString("station_addr","01"),
                                ))
                    
        
                        latchXminusController (CanOpenEPOS24,  //CanOpenEPOS24-3
                                argMap(
                                    aString("nodeID","4"),
                                    aString("serialNB","84004711"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:2,
                                        ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                                        ThermalTimeConstantWinding:40,
                                        MaxSpeedInCurrentMode:100]),
                                    aMap("paramsForProfilePosition", [MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of latchController's children
                            }//end description of latchController's children

                        // can open devices
                        linearRailMasterController (CanOpenEPOS70, 
                                argMap(
                                    aString("nodeID","2a"),
                                    aString("serialNB","80001881"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:260,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:1207,
                                        ProfileDeceleration:1207,
                                        MaxProfileVelocity:322,
                                        QuickStopDeceleration:1207,
                                        MaxFollowingError:200000,//on verra plus tard
                                        ProfileVelocity:281,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailMasterController's children
                            }//end description of linearRailMasterController's children

                        // can open devices
                        linearRailSlaveController (CanOpenEPOS70, 
                                argMap(
                                    aString("nodeID","2b"),
                                    aString("serialNB","80001932"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:10, PositionSensorType:1,PolePairNumber:1,
                                        ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                                        ThermalTimeConstantWinding:187,
                                        MaxSpeedInCurrentMode:9140]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:30000,
                                        ProfileDeceleration:30000,
                                        ProfileVelocity:7000,
                                        QuickStopDeceleration:30000,
                                        MaxFollowingError:7000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",[HomeOffset:0]),
                                    ))
                                    
                            {//begin description of linearRailSlaveController's children
                            }//end description of linearRailSlaveController's children

                        // can open devices
                        onlineClampXminusController (CanOpenEPOS24, 
                                argMap(
                                    aString("nodeID","3a"),
                                    aString("serialNB","79011616"),
                                    aMap("paramsForCurrent", 
                                        [MotorType:1, PositionSensorType:0,PolePairNumber:1,
                                        ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                                        ThermalTimeConstantWinding:419, //160?
                                        MaxSpeedInCurrentMode:6930]),
                                    aMap("paramsForProfilePosition", 
                                        [ProfileAcceleration:10000,
                                        ProfileDeceleration:10000,
                                        ProfileVelocity:1000,
                                        QuickStopDeceleration:10000,
                                        MaxFollowingError:2000,
                                        MotionProfileType:0]),
                                    aMap("paramsForHoming",
                                        [HomeOffset:0, MaxProfileVelocity:6930,
                                        SpeedForSwitchSearch:100,
                                        SpeedForZeroSearch:10,
                                        HomingAcceleration:1000,
                                        CurrentThresholdHomingMode:500,
                                        HomePosition:0
                                        ]),
                                    ))
                                    
                            {//begin description of linearRailSlaveController's children
                            }//end description of linearRailSlaveController's children


                            
                }//end description of bridge's children

       
               inclinometer (InclinometerModule, 
                                argMap(
                                    aString("plutoGatewayName",plutoGatewayName,
                                        [static:true,description:"The name of the pluto gateway where this inclinometer is plugged."]),
               ))

                onlineClampXminus (AutochangerOnlineClampModule ,
                    argMap(
                    ref("controller","onlineClampXminusController"),
                    ref("lockSensor","lockSensorClampXminus"),
                    ref("lockSensorC","lockSensorCClampXminus"),
                    ref("unlockSensor","unlockSensorClampXminus"),
                    ref("unlockSensorC","unlockSensorCClampXminus"),
                    aMap("paramsForCurrentToLock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to clamp the clamp."]),
                    aMap("paramsForCurrentToUnlock", [ContinuousCurrentLimit:5000,OutputCurrentLimit:10000,MaxSpeedInCurrentMode:6930],[description:"list of parameters for CURRENT mode to open the clamp in the initialisation phase."]),  
                ))
            
                    {//begin description of autochanger onlineClampXminus children

                            "lockSensorClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName),
                                    anInt("inputNumero", 0),
                                    anInt("byteNumero", 3),
                                ))

                            "lockSensorCClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName),
                                    anInt("inputNumero", 1),
                                    anInt("byteNumero", 3),
                                ))
                            "unlockSensorClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName),
                                    anInt("inputNumero", 2),
                                    anInt("byteNumero", 3),
                                ))

                            "unlockSensorCClampXminus" ( CanOpenNumericSensor,
                                argMap(
                                    aString("dioName",plutoGatewayName),
                                    anInt("inputNumero", 3),
                                    anInt("byteNumero", 3),
                                ))

                    }//end of  description of autochanger onlineClampXminus children
            
                        //*************************************//
                        // autochanger latchXminus description
                        //*************************************//
                        latchXminus (AutochangerLatchModule,
                            argMap(
                                ref("latchController","latchXminusController"),
                                ref("lockSensor","lockSensorLatchXminus"),
                                ref("unlockSensor","unlockSensorLatchXminus"),
                                ref("filterPresenceSensor","filterPresenceSensorLatchXminus"),
                                ))
                        {//begin description of autochanger latchXminus children
                        "lockSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap(
                                aString("dioName",plutoGatewayName),
                                anInt("inputNumero", 1),
                                anInt("byteNumero", 2),
                            ))

                        "unlockSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap( 
                                aString("dioName",plutoGatewayName),
                                anInt("inputNumero", 2),
                                anInt("byteNumero", 2),
                            ))

                        "filterPresenceSensorLatchXminus" ( CanOpenNumericSensor,
                            argMap( 
                                aString("dioName",plutoGatewayName),
                                anInt("inputNumero", 3),
                                anInt("byteNumero", 2),
                            ))
                        }//end description of autochanger latchXminus children
                        //**********************************************//
                        // end of autochanger latchXminus description   //
                        //**********************************************//


                        trucks (AutoChangerTrucksModule, 
                            argMap(
                                ref("handoffPositionSensor0"),
                                ref("handoffPositionSensor1"),
                                ref("onlinePositionSensor0"),
                                ref("onlinePositionSensor1"),
                                ref("standbyPositionSensor0"),
                                ref("standbyPositionSensor1"),
                            ))
               
                    {//begin description of autochanger trucks children

                        "handoffPositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 0),
                            anInt("byteNumero", 1),
                            ))
                        "handoffPositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 1),
                            anInt("byteNumero", 1),
                            ))
                        "onlinePositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 2),
                            anInt("byteNumero", 1),
                            ))
                        "onlinePositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 3),
                            anInt("byteNumero", 1),
                            ))
                        "standbyPositionSensor0" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 4),
                            anInt("byteNumero", 1),
                            ))
                        "standbyPositionSensor1" ( CanOpenNumericSensor ,
                            argMap(
                            aString("dioName",plutoGatewayName),
                            anInt("inputNumero", 5),
                            anInt("byteNumero", 1),
                            ))                                       
                    }//end description of autochanger trucks children

//                 }//end description of autochanger children


            }//end description of Main submodules

                


