
package loader

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder


def plutoGatewayName = "loaderPlutoGateway" // to monitor the loader sensors
def loaderTcpProxyName = "loaderTcpProxy" // the name of the tcpProxy

CCSBuilder builder = ["loader-standalone"]

builder.
    main ( LoaderMainModule, bridge:ref("bridgeToLoader"))
{ //begin description of Main submodules

    autochanger(FakeFilterHolder, plutoGatewayName:plutoGatewayName,
        holdingFilterSensor:ref("autochangerHoldingFilterSensor"))
    {//begin description of fakeAutochanger's children 
    
        autochangerHoldingFilterSensor(CanOpenNumericSensor,
            dioName:plutoGatewayName, inputNumero:1,byteNumero:4)
    }//end description of fakeAutochanger's children

    // Bridge
    bridgeToLoader (BridgeToCanOpenHardware,tcpProxy:ref(loaderTcpProxyName))
    {//begin description of bridge's children          
        
        // tcp Proxy
        loaderTcpProxy (CanOpenProxy,
            portNumber:50000,fieldBusTimeout:6000,clientName:"TestBench",
            hardwareBootTimeout:1000)
                 
        // can open devices
        hooksController (CanOpenEPOS24,
            nodeID:"1b",serialNB:"79007141",
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition:[
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]) 
                        
        carrierController (CanOpenEPOS70,nodeID:"1a",serialNB:"80003184",
            paramsForCurrent:[
                ContinuousCurrentLimit:7290,
                OutputCurrentLimit:14580,
                MaxSpeedInCurrentMode:9840,
                MotorType:10,
                PositionSensorType:4,
                ThermalTimeConstantWinding:187,
                PolePairNumber:1],
            paramsForProfilePosition:[
                MinPositionLimit:-2147483648,
                MaxPositionLimit:1037000,
                MotionProfileType:0,
                MaxFollowingError:6000,
                MaxProfileVelocity:186, 
                ProfileVelocity:80,
                ProfileAcceleration:50,
                ProfileDeceleration:50,
                QuickStopDeceleration:10000],
            paramsForHoming:[
                HomeOffset:0,
                HomingAcceleration:200,
                CurrentThresholdHomingMode:500])
                        
            "$plutoGatewayName" (LoaderCanOpenPlutoGateway, 
            nodeID:"1",serialNB:"22d6",station_addr:"00")
                            
    }//end description of bridge's childrens
                
    //begin description of loader
    loader (LoaderModule,
        carrier:ref("carrier"),
        clamp:ref("clamp"),
        plutoGatewayName:plutoGatewayName,
        filterPresenceSensor0:ref("filterPresenceSensor0"),
        filterPresenceSensor1:ref("filterPresenceSensor1"),
        loaderOnCameraSensor0:ref("loaderOnCameraSensor0"),
        loaderOnCameraSensor1:ref("loaderOnCameraSensor1"))
    {//begin description of loader's children

        carrier(LoaderCarrierModule,
            handoffPositionSensor:ref("loaderHandoffPositionSensor0"),
            handoffPositionSensor1:ref("loaderHandoffPositionSensor1"),
            storagePositionSensor:ref("loaderStoragePositionSensor0"),
            storagePositionSensor1:ref("loaderStoragePositionSensor1"))
        {//begin description of loader carrier's children  
            loaderHandoffPositionSensor0 ( CanOpenNumericSensor ,
                dioName:plutoGatewayName,inputNumero:6,byteNumero:1)

            loaderHandoffPositionSensor1 ( CanOpenNumericSensor ,
                dioName:plutoGatewayName,inputNumero:7,byteNumero:1)

            loaderStoragePositionSensor0 ( CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero:4,byteNumero:1)

            loaderStoragePositionSensor1 ( CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero:5, byteNumero:1)                                     
        }//end description of loader carrier's children

        clamp(LoaderClampModule,
            hook1:ref("hook1"),hook2:ref("hook2"), hook3:ref("hook3"),hook4:ref("hook4"),
            paramsForCurrentToClamp:[
                ContinuousCurrentLimit:410,
                OutputCurrentLimit:820,
                MaxSpeedInCurrentMode:500],
            paramsForCurrentToGoHomePosition:[
                ContinuousCurrentLimit:500,
                OutputCurrentLimit:1000,
                MaxSpeedInCurrentMode:500])
        {//begin description of loader clamp's children
            int[] inputNumeroLock = [4,5,6,7];
            int[] inputNumeroUnlock = [0,1,2,3];
            for (int i = 1; i<5; i++) {
            
            "hook${i}"(LoaderHookModule,
                    lockSensor:ref("loaderLockSensor${i}"), unlockSensor:ref("loaderUnlockSensor${i}"))
                {
                    "loaderLockSensor${i}" ( CanOpenNumericSensor , //closeHookSensor0
                        dioName:plutoGatewayName, inputNumero:inputNumeroLock[i-1], byteNumero:0)
                       
                    "loaderUnlockSensor${i}" ( CanOpenNumericSensor , //openHookSensor0
                        dioName:plutoGatewayName, inputNumero:inputNumeroUnlock[i-1], byteNumero:0)
                }
            }
            
            filterPresenceSensor0(CanOpenNumericSensor ,
                dioName:plutoGatewayName,inputNumero:0, byteNumero:1)

            filterPresenceSensor1(CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero:1, byteNumero:1)                                     

            loaderOnCameraSensor0(CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero:2, byteNumero:1)

            loaderOnCameraSensor1(CanOpenNumericSensor ,
                dioName:plutoGatewayName, inputNumero:3, byteNumero:1)

            }//end description of loader's children
            
    }//end description of Main submodules
}
                


