#!/bin/sh

#Directory where one can find the groovy description files
source .setupFCS_BIN
echo "RESOURCES_DIR=$RESOURCES_DIR"


#the SOCKET_MODEL is used to generate automaticaly the sockets description files
SOCKET_MODEL_FILENAME=socket__simulation__model.groovy
echo "SOCKET_MODEL_FILENAME=$SOCKET_MODEL_FILENAME"

#the file this script is going to generate
CAROUSEL_FILENAME=carousel__simulation.groovy

#head file
CAROUSEL_SUBS_HEAD=carousel-standalone_head

#bridge to carousel hardware filename 
B_CAROUSEL_STANDALONE_DESC=bridgeToCarouselSTANDALONE_description

#filterManager description filename
FILTER_MGR_DESC=filterManager_description

#Fake autochanger Description
FAKE_AC_DESC=fakeAutochangerForCarouselStandalone_description

#begin description of carousel file
CAROUSEL_HEAD=carousel__head

#tail file
CAROUSEL_TAIL=carousel__tail

#Directory to save files
TMPDIR=/Users/virieux/tmp/

cd $RESOURCES_DIR

### Test if SOCKET_MODEL exists ###
if [ -f $SOCKET_MODEL_FILENAME ]; then 
	echo "Generation of sockets file from model SOCKET_MODEL_FILENAME=$SOCKET_MODEL_FILENAME";
        echo "The generated files are in $TMPDIR"
else
	echo "ERROR in execution of $0: $SOCKET_MODEL_FILENAME : no such file or directory in $RESOURCES_DIR"; 
	exit 0; 
fi

### SOCKET_MODEL exists ####

SOCKET_NUMBER=1; while [ $SOCKET_NUMBER -lt 6 ] ;
do
 echo "Generation of description groovy file for socket$SOCKET_NUMBER";
 cat $SOCKET_MODEL_FILENAME | sed -e "s/SOCKET_NUMBER/$SOCKET_NUMBER/g" > $TMPDIR/socket$SOCKET_NUMBER
 SOCKET_NUMBER=`expr $SOCKET_NUMBER + 1`;
done

### save existing carousel description file ###
echo "Saving $CAROUSEL_FILENAME in $TMPDIR"
DATE=`date '+%Y%m%d_%H%M%S'`
cp $CAROUSEL_FILENAME $TMPDIR/$CAROUSEL_FILENAME.$DATE

### Generation of file CAROUSEL_FILENAME
echo "Generation of $CAROUSEL_FILENAME from $CAROUSEL_SUBS_HEAD $B_CAROUSEL_STANDALONE_DESC $FILTER_MGR_DESC $FAKE_AC_DESC $CAROUSEL_HEAD, sockets files and $CAROUSELTAIL"
chmod u+w $CAROUSEL_FILENAME
cat $CAROUSEL_SUBS_HEAD $B_CAROUSEL_STANDALONE_DESC $FILTER_MGR_DESC $FAKE_AC_DESC $CAROUSEL_HEAD $TMPDIR/socket1 $TMPDIR/socket2 $TMPDIR/socket3 $TMPDIR/socket4 $TMPDIR/socket5 $CAROUSEL_TAIL > $CAROUSEL_FILENAME

echo "}    // main" >> $CAROUSEL_FILENAME
chmod u-w $CAROUSEL_FILENAME

