/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;

public final class FcsUtils {
    public static final int MAX_VALUE_2BYTES = 65535;
    public static final int MAX_NODE_ID = 127;
    private static final String SOCKET_NAME = "socket";

    public static void checkSocketName(String name) {
        String errorMsg = ": invalid socket name - Socket name must be \"socketX\" where 0 <= X <= 5";
        if (name.isEmpty() || name.contentEquals("AC")) {
            return;
        }
        if (!name.startsWith(SOCKET_NAME)) {
            throw new IllegalArgumentException(name + errorMsg);
        }
        String end = name.substring(6);
        try {
            int ix = Integer.parseInt(end);
            if (ix < 1 || ix > 5) {
                throw new IllegalArgumentException(name + errorMsg);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(name + errorMsg, ex);
        }
    }

    public static StatusDataPublishedByHardware createStatusDataPublishedByHardware(PieceOfHardware device) {
        return new StatusDataPublishedByHardware(device.getName(), device.isBooted(), device.isInitialized());
    }

    public static StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController(EPOSController ctlr) {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(ctlr.getName(), ctlr.isBooted(), ctlr.isInitialized());
        status.setInError(ctlr.isInError());
        status.setErrorRegister(ctlr.getErrorRegister());
        status.setErrorHistory(ctlr.getErrorHistory());
        status.setEnabled(ctlr.isEnabledToPublish());
        status.setMode(ctlr.getMode());
        return status;
    }

    public static String binaryToHex(String bin) {
        int binaryToInt = Integer.parseInt(bin, 2);
        return Integer.toHexString(binaryToInt);
    }

    public static String hexToBinary(String Hex) {
        int integer = Integer.parseInt(Hex, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%08d", Integer.parseInt(bin));
    }

    public static String twoBytesInHexaToBinary(String twoBytesInHexa) {
        int integer = Integer.parseInt(twoBytesInHexa, 16);
        String bin = Integer.toBinaryString(integer);
        return String.format("%016d", Long.parseLong(bin));
    }

    public static String replaceDigit(String twoBytesInHexa, int bitPosition, String digit) {
        if (bitPosition < 0 || bitPosition > 15) {
            throw new IllegalArgumentException("replaceDigit:  bitPosition must be: 0< bitPosition <15");
        }
        if (!digit.equals("0") && !digit.equals("1")) {
            throw new IllegalArgumentException("replaceDigit:  digit must 0 or 1");
        }
        StringBuilder bin = new StringBuilder(FcsUtils.twoBytesInHexaToBinary(twoBytesInHexa));
        bin.replace(15 - bitPosition, 15 - bitPosition + 1, digit);
        return Integer.toHexString(Integer.parseInt(bin.toString(), 2));
    }

    public static String force2zero(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append('1');
        }
        sb.setCharAt(16 - (pos + 1), '0');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal & mask;
        return Integer.toHexString(myNewVal);
    }

    public static String force2one(String hexaVal, int pos) {
        if (pos < 0 || pos > 15) {
            throw new IllegalArgumentException(String.format("bad value for bit=%s - must be : 0<= bit <= 15", pos));
        }
        int intVal = Integer.parseInt(hexaVal, 16);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append('0');
        }
        sb.setCharAt(16 - (pos + 1), '1');
        int mask = Integer.parseInt(sb.toString(), 2);
        int myNewVal = intVal | mask;
        return Integer.toHexString(myNewVal);
    }

    public static int[] toReverseBinary(int decimal) {
        int[] tab = new int[16];
        for (int i = 0; i < 16; ++i) {
            int bit;
            tab[i] = bit = decimal >> i & 1;
        }
        return tab;
    }

    public static String buildWsdoCommand(String nodeID, String index, String subindex, String size, String data) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("wsdo").append(sep);
        sb.append(nodeID).append(sep);
        sb.append(index).append(sep);
        sb.append(subindex).append(sep);
        sb.append(size).append(sep);
        sb.append(data);
        return sb.toString();
    }

    public static String buildRsdoCommand(String nodeID, String index, String subindex) {
        char sep = ',';
        StringBuilder sb = new StringBuilder("rsdo").append(sep);
        sb.append(nodeID).append(sep);
        sb.append(index).append(sep);
        sb.append(subindex);
        return sb.toString();
    }

    public static int convertToInteger16(int unsigned16) {
        if (unsigned16 < 32768) {
            return unsigned16;
        }
        return unsigned16 - 65535;
    }

    public static String displayListParameters(String modeInString) {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters for mode: ");
        sb.append(modeInString);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.EposMode.valueOf((String)modeInString).getParameters()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String displayListParameters() {
        EPOSEnumerations.Parameter[] params;
        StringBuilder sb = new StringBuilder("List of parameters : ");
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = EPOSEnumerations.Parameter.values()) {
            sb.append(param.display());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static int addAngle(int angle1, int angle2) {
        int angle = angle1 + angle2;
        int result = angle % 360;
        if (result < 0) {
            result += 360;
        }
        return result;
    }

    public static int computeRotationShortestWay(int angle) {
        if (Math.abs(angle) > 360) {
            throw new IllegalArgumentException(angle + " invalid value");
        }
        if (Math.abs(angle) < 180) {
            return angle;
        }
        if (angle > 0) {
            return angle - 360;
        }
        return angle + 360;
    }

    public static void main(String[] args) {
        System.out.println(FcsUtils.displayListParameters("HOMING"));
        System.out.println(FcsUtils.displayListParameters("CURRENT"));
        System.out.println(FcsUtils.displayListParameters("PROFILE_POSITION"));
        System.out.println(FcsUtils.displayListParameters());
    }
}

