/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenThermometer;
import org.lsst.ccs.subsystems.fcs.testbench.CanOpenLED;

public class APCTestBenchMainModule
extends Module {
    private final BridgeToHardware bridge;
    private final CanOpenThermometer thermometer;
    private final CanOpenLED led;
    private final CanOpenLED fakeLed;
    private final CanOpenThermometer fakeSensor;
    public double temperature;

    public APCTestBenchMainModule(String name, int tickMillis, BridgeToHardware bridge, CanOpenThermometer thermometer, CanOpenLED led, CanOpenLED fakeLed, CanOpenThermometer fakeSensor) {
        super(name, tickMillis);
        this.bridge = bridge;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
    }

    public int getReturnValue(String responseLine, int inputNB) {
        if (inputNB < 1 || inputNB > 8) {
            throw new IllegalArgumentException();
        }
        String[] words = responseLine.split(",");
        FCSCst.FCSLOG.debug((Object)("Value in HEXA:" + words[inputNB]));
        int value = Integer.parseInt(words[inputNB], 16);
        FCSCst.FCSLOG.debug((Object)("Value in decimal:" + words[inputNB]));
        return value;
    }

    public double readTemperature() {
        return this.thermometer.readTemperature();
    }

    public double readTemperatureFromPDO() {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.thermometer.readTemperatureWithPDO(pdoStore);
    }

    public String turnOnLED() {
        return this.led.turnON();
    }

    public String turnOffLED() {
        return this.led.turnOFF();
    }

    public String turnOnFakeLED() {
        return this.fakeLed.turnON();
    }

    public String turnOffFakeLED() {
        return this.fakeLed.turnOFF();
    }

    public double readFakeSensor() {
        PDOStorage pdoStore = this.bridge.readPDOs();
        return this.fakeSensor.readTemperatureWithPDO(pdoStore);
    }
}

