/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCompactIOModule;

public class SimuLatchActuatorModule
extends LatchActuatorModule {
    private SimuCompactIOModule simuDIO;
    private final String filterSensorsDIOName;

    public SimuLatchActuatorModule(double currentLimitInVolt, double speedVoltageInVolt, int speedVoltageMinValue, int speedVoltageMaxValue, String filterSensorsDIOName) {
        super(currentLimitInVolt, speedVoltageInVolt, speedVoltageMinValue, speedVoltageMaxValue);
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public void initModule() {
        this.simuDIO = (SimuCompactIOModule)this.getComponentLookup().getComponentByName(this.filterSensorsDIOName);
    }

    @Override
    public String open() {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        ComponentLookup lookup = this.getComponentLookup();
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXminus"))).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXminus"))).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXplus"))).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXplus"))).getInputNumero();
        } else {
            throw new FailedCommandException(this.getName() + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "0", unlockSensorInputNumero, "1");
        FCSCst.FCSLOG.debug((Object)(this.getName() + " is OPEN"));
        return this.getName() + " is OPEN";
    }

    @Override
    public String close() {
        int unlockSensorInputNumero;
        int lockSensorInputNumero;
        ComponentLookup lookup = this.getComponentLookup();
        if (this.getName().endsWith("Xminus")) {
            lockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXminus"))).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXminus"))).getInputNumero();
        } else if (this.getName().endsWith("Xplus")) {
            lockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("lockSensorLatchXplus"))).getInputNumero();
            unlockSensorInputNumero = ((NumericSensor)((Object)lookup.getComponentByName("unlockSensorLatchXplus"))).getInputNumero();
        } else {
            throw new FailedCommandException(this.getName() + " Can't retrieve the latch for which I work.");
        }
        this.simuDIO.replaceDigitalValues(lockSensorInputNumero, "1", unlockSensorInputNumero, "0");
        return this.getName() + " is CLOSED";
    }

    @Override
    public String powerOff() {
        return this.getName() + " is OFF";
    }
}

