/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuCompactIOModule
extends CompactIOModule {
    @ConfigurationParameter
    private String initialHexaValue;
    private NumericSensor filterPresenceSensorLatchXminus;
    private NumericSensor filterPresenceSensorLatchXplus;

    public SimuCompactIOModule(String nodeID, String serialNB, String initialHexaValue) {
        super(nodeID, serialNB);
        this.initialHexaValue = initialHexaValue;
    }

    public String getInitialHexaValue() {
        return this.initialHexaValue;
    }

    public void setInitialHexaValue(String initialHexaValue) {
        this.initialHexaValue = initialHexaValue;
    }

    public void setHexaValue(String hex) {
        this.hexaValue = hex;
    }

    @Override
    public void initModule() {
        this.hexaValue = this.initialHexaValue;
        ComponentLookup lookup = this.getComponentLookup();
        this.filterPresenceSensorLatchXminus = (NumericSensor)((Object)lookup.getComponentByName("filterPresenceSensorLatchXminus"));
        this.filterPresenceSensorLatchXplus = (NumericSensor)((Object)lookup.getComponentByName("filterPresenceSensorLatchXplus"));
    }

    @Override
    public String readNewHexaValue() {
        return this.hexaValue;
    }

    public void simulateFilterPresenceInLatches(String aDigitalValue) {
        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();
        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    public void replaceDigitalValues(int channel1, String digitalValue1, int channel2, String digitalValue2) {
        if (channel1 < 0 || channel1 > 7) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 0 || channel2 > 7) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (!digitalValue1.equals("0") && !digitalValue1.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (!digitalValue2.equals("0") && !digitalValue2.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + "=> old hexa value = " + this.hexaValue));
        StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValue));
        bin.replace(7 - channel1, 7 - channel1 + 1, digitalValue1);
        bin.replace(7 - channel2, 7 - channel2 + 1, digitalValue2);
        String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
        FCSCst.FCSLOG.debug((Object)(this.getName() + "=> new hexa value =" + newDIOHexaValue));
        this.hexaValue = newDIOHexaValue;
    }
}

