/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftUtils;

public class SftFilterLatchModule
extends MobileItemModule {
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private FcsEnumerations.FilterPresenceStatus presenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    protected final LatchActuatorModule latchActuator;
    protected NumericSensor filterPresenceSensor;
    protected NumericSensor lockSensor;
    protected NumericSensor unlockSensor;
    private CompactIOModule filterSensorsDIO;
    private final String filterSensorsDIOName;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the autochanger latches last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForOpening = 10000L;
    @ConfigurationParameter(description="timeout in milliseconds : if opening the autochanger latches last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClosing = 10000L;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public SftFilterLatchModule(String filterSensorsDIOName, NumericSensor lockSensor, NumericSensor unlockSensor, NumericSensor filterPresenceSensor, LatchActuatorModule latchActuator) {
        super(5000);
        this.filterSensorsDIOName = filterSensorsDIOName;
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
        this.filterPresenceSensor = filterPresenceSensor;
        this.latchActuator = latchActuator;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public LatchActuatorModule getLatchActuator() {
        return this.latchActuator;
    }

    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public boolean isControllerInFault() {
        return false;
    }

    @Override
    public void initModule() {
        this.filterSensorsDIO = (CompactIOModule)this.getComponentLookup().getComponentByName(this.filterSensorsDIOName);
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.presenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latch must be OPEN or CLOSE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Command(level=1, description="Read latch sensors and update latch state", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() {
        this.filterSensorsDIO.updateValue();
        String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
        this.updateState(filterSensorsHexaValue);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws FcsHardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            this.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            this.latchActuator.close();
        } else {
            throw new IllegalArgumentException(this.getName() + "Action on latch must be OPEN or CLOSE");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.publishData();
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": getLockStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getPresenceStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": getPresenceStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.FilterPresenceStatus filterPresenceStatus = this.presenceStatus;
            return filterPresenceStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    public StatusDataPublishedByAutochangerLatch getStatusData() {
        return SftUtils.createStatusDataPublishedByLatch(this);
    }

    @Command(level=3, description="Open latch", type=Command.CommandType.ACTION)
    public String open() {
        this.updateStateWithSensors();
        if (!this.isLocked()) {
            return this.getName() + "is already OPEN";
        }
        CarouselModule carousel = (CarouselModule)this.getComponentLookup().getComponentByName("carousel");
        if (!carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + "CANNOT OPEN LATCH at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
        this.latchActuator.powerOff();
        return this.getName() + " is OPEN";
    }

    @Command(level=3, description="Close latch", type=Command.CommandType.ACTION)
    public String close() {
        this.updateStateWithSensors();
        if (this.isLocked()) {
            return this.getName() + "is already CLOSED";
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
        this.latchActuator.powerOff();
        return this.getName() + " is CLOSED";
    }

    @Command(level=1, description="Return true if the latch is closed", type=Command.CommandType.QUERY)
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public void updateState(String hexaValue) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(hexaValue);
            this.lockSensor.updateValue(hexaValue);
            this.unlockSensor.updateValue(hexaValue);
            this.presenceStatus = this.filterPresenceSensor.getDigitalValue() == 1 ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.NOFILTER;
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            boolean bl = this.inError = this.locked && this.unlocked;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.locked ? FcsEnumerations.LockStatus.LOCKED : (this.unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.getStatusData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochangerLatch", (Serializable)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/ lock sensor=");
        sb.append(this.lockSensor.getName());
        sb.append("/ unlock sensor=");
        sb.append(this.unlockSensor.getName());
        sb.append("/ filter presence sensor=");
        sb.append(this.filterPresenceSensor.getName());
        return sb.toString();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

