/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

public class CanOpenTruckMotor
extends SftTruckMotor {
    private CompactIOModule dio;
    @ConfigurationParameter(isFinal=true, description="The name of the DIO (Digital Input Output module) which controls this motor.")
    private final String dioName;
    @ConfigurationParameter(range="0..7", description="The numero of the output of DIO where we send a current for the trucks to go to standby")
    private final int outputNumeroToStandby;
    @ConfigurationParameter(range="0..7", description="The numero of the output of DIO where we send a current for the trucks to go to standback")
    private final int outputNumeroToStandback;

    public CanOpenTruckMotor(String dioName, int outputNumeroToStandby, int outputNumeroToStandback) {
        this.dioName = dioName;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }

    public void initModule() {
        this.dio = (CompactIOModule)this.getComponentLookup().getComponentByName(this.dioName);
    }

    @Override
    public String moveToStandback() {
        this.setMovingToStandback(true);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), "6200", "1", "1", "1");
    }

    @Override
    public String moveToStandby() {
        this.setMovingToStandby(true);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), "6200", "1", "1", "2");
    }

    @Override
    public String off() {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return this.dio.getTcpProxy().writeSDO(this.dio.getNodeID(), "6200", "1", "1", "0");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(this.outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(this.outputNumeroToStandback);
        return sb.toString();
    }
}

