/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.io.Serializable;
import java.util.Observable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.common.ModuleState;
import org.lsst.ccs.subsystems.fcs.errors.ClampsOrLatchesDisagreeException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftFilterLatchModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftUtils;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.TruckModule;

public abstract class BasicAutoChangerModule
extends MobileItemModule
implements FilterHolder {
    @ConfigurationParameter(description="The name of the DIO where the rails sensors are plugged.")
    private String railsSensorsDIOName;
    @ConfigurationParameter(description="The name of the DIO where the filter sensors are plugged.")
    private String filterSensorsDIOName;
    private boolean trucksEmpty;
    private Filter filterOnTrucks;
    protected CarouselModule carousel;
    private FcsEnumerations.AutoChangerTrucksLocation trucksLocation;
    private final SftFilterLatchModule latchXminus;
    private final SftFilterLatchModule latchXplus;
    protected TruckModule truckXminus;
    protected TruckModule truckXplus;
    private CompactIOModule railsSensorsDIO;
    private CompactIOModule filterSensorsDIO;
    public static final String publishedByAutoChangerOutputName = "publishedByAutoChanger";
    protected volatile ModuleState state = ModuleState.HALTED;
    private volatile FcsEnumerations.FilterPresenceStatus presenceStatus;
    protected volatile FcsEnumerations.LockStatus latchesState;
    protected volatile boolean updatingLatches = false;
    protected volatile boolean closingLatches = false;
    protected volatile boolean openingLatches = false;
    private volatile boolean updatingTrucksLocation = false;
    private final Condition stateUpdated = this.lock.newCondition();
    private final Condition trucksLocationUpdated = this.lock.newCondition();
    protected long timeoutForOpeningLatches;
    protected long timeoutForClosingLatches;

    public BasicAutoChangerModule(SftFilterLatchModule latchXminus, SftFilterLatchModule latchXplus, TruckModule truckXminus, TruckModule truckXplus, String railsSensorsDIOName, String filterSensorsDIOName) {
        this.latchXminus = latchXminus;
        this.latchXplus = latchXplus;
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.railsSensorsDIOName = railsSensorsDIOName;
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public CompactIOModule getRailsSensorsDIO() {
        return this.railsSensorsDIO;
    }

    public CompactIOModule getFilterSensorsDIO() {
        return this.filterSensorsDIO;
    }

    public Filter getFilterOnTrucks() {
        return this.filterOnTrucks;
    }

    public ModuleState getState() {
        return this.state;
    }

    public void setState(ModuleState state) {
        this.state = state;
    }

    public SftFilterLatchModule getLatchXminus() {
        return this.latchXminus;
    }

    public SftFilterLatchModule getLatchXplus() {
        return this.latchXplus;
    }

    public TruckModule getTruckXminus() {
        return this.truckXminus;
    }

    public TruckModule getTruckXplus() {
        return this.truckXplus;
    }

    public boolean isTrucksEmpty() {
        return this.trucksEmpty;
    }

    public void setTrucksEmpty(boolean isEmpty) {
        this.trucksEmpty = isEmpty;
    }

    public void setFilterOnTrucks(Filter filterOnTrucks) {
        this.filterOnTrucks = filterOnTrucks;
    }

    public String getFilterOnTrucksName() {
        if (this.filterOnTrucks == null) {
            return "none";
        }
        return this.filterOnTrucks.getName();
    }

    public String getFilterSensorsDIOName() {
        return this.filterSensorsDIOName;
    }

    public void setFilterSensorsDIOName(String filterSensorsDIOName) {
        this.filterSensorsDIOName = filterSensorsDIOName;
    }

    public String getRailsSensorsDIOName() {
        return this.railsSensorsDIOName;
    }

    public void setRailsSensorsDIOName(String railsSensorsDIOName) {
        this.railsSensorsDIOName = railsSensorsDIOName;
    }

    public abstract boolean isMovingToStandback();

    public abstract boolean isMovingToStandby();

    @Override
    public void initModule() {
        FCSLOG.info((Object)"[AutoChangerModule] Initializing the Auto Changer module ");
        this.trucksLocation = FcsEnumerations.AutoChangerTrucksLocation.UNKNOWN;
        this.latchesState = FcsEnumerations.LockStatus.UNKNOWN;
        ComponentLookup lookup = this.getComponentLookup();
        this.carousel = (CarouselModule)lookup.getComponentByName("carousel");
        this.filterSensorsDIO = (CompactIOModule)lookup.getComponentByName(this.filterSensorsDIOName);
        this.railsSensorsDIO = (CompactIOModule)lookup.getComponentByName(this.railsSensorsDIOName);
        this.timeoutForClosingLatches = Math.max(this.latchXminus.getTimeoutForClosing(), this.latchXplus.getTimeoutForClosing());
        this.timeoutForOpeningLatches = Math.max(this.latchXminus.getTimeoutForOpening(), this.latchXplus.getTimeoutForOpening());
        SftTruckMotor sftTrucksMotor = (SftTruckMotor)((Object)lookup.getComponentByName("sftTrucksMotor"));
        if (sftTrucksMotor == null) {
            FCSLOG.error((Object)(this.getName() + "==>>> sftTrucksMotor == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.getName() + "==>>> null sftTrucksMotor - fix groovy description file.");
        }
        this.listens(new Observable[]{sftTrucksMotor});
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isCANDevicesReady() {
        return ((MainModule)this.getComponentLookup().getComponentByName("main")).isCANDevicesReady();
    }

    public void tick() {
        this.publishData();
    }

    public void processUpdate(Observable source, Module.ValueUpdate v) {
        FCSLOG.debug((Object)(this.getName() + "===> PROCESS_UPDATE from " + source.toString()));
        this.publishDataAndNotifyObservers();
    }

    public StatusDataPublishedByBasicAutoChanger getStatusData() {
        return SftUtils.createStatusDataPublishedByBasicAutoChanger(this);
    }

    public void publishDataAndNotifyObservers() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.publishData();
        this.setChanged();
        this.notifyObservers(new Module.ValueUpdate((Module)this, publishedByAutoChangerOutputName, (Object)status));
    }

    @Override
    public void publishData() {
        StatusDataPublishedByBasicAutoChanger status = this.getStatusData();
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData("autochanger", (Serializable)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("\n");
        sb.append("Trucks position = ");
        sb.append("Filter on trucks:");
        if (this.filterOnTrucks == null) {
            sb.append(" NONE").append("\n");
        } else {
            sb.append(this.filterOnTrucks.getName()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public abstract boolean isMoving();

    public abstract String goToStandby();

    public abstract String goToStandback();

    public abstract String moveFilterToStandby(Filter var1);

    public abstract String moveFilterToStandback(Filter var1);

    @Override
    public abstract void updateStateWithSensors();

    @Command(level=1, description="checks if the preconditions are ok before a motion of the trucks can be started", type=Command.CommandType.QUERY)
    public void checkPreConditionsForTrucksMotion() {
        FCSLOG.info((Object)"Checking pre-conditions for trucks motion");
        this.updateLatchesStateWithSensors();
        FCSLOG.debug((Object)(this.getName() + " LATCHES STATUS= " + this.latchesState.toString()));
        if (this.latchesState == FcsEnumerations.LockStatus.ERROR) {
            throw new RejectedCommandException(this.getName() + "Trucks motion forbidden when latches status is ERROR.");
        }
        if (this.latchesState == FcsEnumerations.LockStatus.UNKNOWN) {
            throw new RejectedCommandException(this.getName() + "Trucks motion forbidden when latches status is UNKNOWN.");
        }
        if (!this.trucksEmpty && this.latchesState == FcsEnumerations.LockStatus.UNLOCKED) {
            throw new RejectedCommandException(this.getName() + "Trucks motion forbidden when trucks are loaded and latches are UNLOCKED.");
        }
        if (this.isHoldingFilterAtStandby() && this.carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + "Trucks motion forbidden when both carousel and autochanger are holding filter.");
        }
        FCSLOG.info((Object)"===== Preconditions for trucks motion are checked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(level=1, description="Go to STANDBY to grab filter and stay at STANDBY", type=Command.CommandType.ACTION)
    public String grabFilterAtStandby(Filter filter) {
        if (this.filterOnTrucks != null) {
            throw new RejectedCommandException(this.getName() + ": can't grab a filter when a filter is already loaded in trucks ");
        }
        FCSLOG.info((Object)(this.getName() + ": grabbing " + filter.getName() + " at standby position."));
        this.goToStandby();
        this.closeLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = filter;
            this.setTrucksEmpty(false);
            this.filterOnTrucks.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        }
        this.publishData();
        String ack = this.getName() + ": " + filter.getName() + " is grabbed on autochanger";
        FCSLOG.info((Object)ack);
        return ack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(level=1, description="Ungrab filter at STANDBY and go back to HANDOFF", type=Command.CommandType.ACTION)
    public String ungrabFilterAtStandby() {
        FCSLOG.info((Object)(this.getName() + ": ungrabbing filter at standby position."));
        this.openLatchesAtStandby();
        BasicAutoChangerModule basicAutoChangerModule = this;
        synchronized (basicAutoChangerModule) {
            this.filterOnTrucks = null;
            this.setTrucksEmpty(true);
            this.publishDataAndNotifyObservers();
        }
        FCSLOG.info((Object)(this.getName() + " trucks going empty to STANDBACK position"));
        this.goToStandback();
        this.publishData();
        return this.getName() + ": trucks are empty at STANDBACK position ";
    }

    public FcsEnumerations.LockStatus getLatchesState() {
        this.lock.lock();
        try {
            while (this.updatingLatches) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)ex);
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.latchesState;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isHoldingFilter() {
        return this.isHoldingFilterAtStandby();
    }

    @Command(level=1, description="Return true if the trucks are at STANDBY position and hold a filter", type=Command.CommandType.QUERY)
    public boolean isHoldingFilterAtStandby() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandby()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the trucks are at STANDBACK position and hold a filter")
    public boolean isHoldingFilterAtStandback() {
        if (this.isMoving()) {
            return false;
        }
        if (!this.isAtStandback()) {
            return false;
        }
        if (this.isTrucksEmpty()) {
            return false;
        }
        return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            return this.getLatchesState().equals((Object)FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latches must be OPENLATCHES or CLOSELATCHES");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.updateLatchesStateWithSensors();
        this.publishData();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPENLATCHES)) {
            this.latchXminus.latchActuator.open();
            this.latchXplus.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSELATCHES)) {
            this.latchXminus.latchActuator.close();
            this.latchXplus.latchActuator.close();
        } else {
            throw new IllegalArgumentException(this.getName() + "Action on latches must be OPENLATCHES or CLOSELATCHES");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.getName() + " stopAction : nothing to be done."));
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.updateLatchesStateWithSensors();
        }
        catch (ClampsOrLatchesDisagreeException ex) {
            FCSLOG.warning((Object)ex);
            FCSLOG.warning((Object)(this.getName() + ": a little delay between the update of the 2 latches : have to wait ..."));
        }
    }

    @Command(level=1, description="Open the 2 latches when the autochanger trucks are at standby position", type=Command.CommandType.ACTION, alias="openLatches")
    public String openLatchesAtStandby() throws FcsHardwareException {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.getName() + "CANNOT OPEN LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        if (!this.carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.getName() + "CANNOT OPEN LATCHES at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPENLATCHES, this.timeoutForOpeningLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are unlocked";
    }

    @Command(level=1, description="Close the 2 latches when the autochanger trucks are at standby position", type=Command.CommandType.ACTION, alias="closeLatches")
    public String closeLatchesAtStandby() {
        this.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.getName() + "CANNOT CLOSE LATCHES at STANDBY : AUTOCHANGER is NOT AT STANDBY");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSELATCHES, this.timeoutForClosingLatches);
        this.latchXminus.latchActuator.powerOff();
        this.latchXplus.latchActuator.powerOff();
        this.publishDataAndNotifyObservers();
        return "Autochanger latches are locked";
    }

    public void updateLatchesStateWithSensors() {
        this.lock.lock();
        this.updatingLatches = true;
        try {
            this.filterSensorsDIO.updateValue();
            String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
            this.latchXminus.updateState(filterSensorsHexaValue);
            this.latchXplus.updateState(filterSensorsHexaValue);
            if (!this.latchXminus.getLockStatus().equals((Object)this.latchXplus.getLockStatus())) {
                throw new ClampsOrLatchesDisagreeException(this.getName() + "Error in latches lock status : the latches don't agree");
            }
            this.latchesState = this.latchXminus.getLockStatus();
            if (!this.latchXminus.getPresenceStatus().equals((Object)this.latchXplus.getPresenceStatus())) {
                throw new ClampsOrLatchesDisagreeException(this.getName() + "Error in latches filter presence status : the latches don't agree.");
            }
            this.presenceStatus = this.latchXminus.getPresenceStatus();
            this.trucksEmpty = !this.latchesState.equals((Object)FcsEnumerations.LockStatus.LOCKED) || !this.presenceStatus.equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED);
            FCSLOG.debug((Object)(this.getName() + ": latches are updated"));
        }
        finally {
            this.updatingLatches = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishDataAndNotifyObservers();
        }
    }

    public FcsEnumerations.AutoChangerTrucksLocation getTrucksLocation() {
        this.lock.lock();
        try {
            while (this.updatingTrucksLocation) {
                try {
                    this.trucksLocationUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)ex);
                }
            }
            FcsEnumerations.AutoChangerTrucksLocation autoChangerTrucksLocation = this.trucksLocation;
            return autoChangerTrucksLocation;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Command(level=1, description="Return true if the trucks are at STANDBY position", type=Command.CommandType.QUERY)
    public boolean isAtStandby() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBY;
    }

    @Command(level=1, description="Return true if the trucks are at STANDBACK position", type=Command.CommandType.QUERY)
    public boolean isAtStandback() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.STANDBACK;
    }

    @Override
    @Command(level=1, description="Return true if the trucks are at HANDOFF position", type=Command.CommandType.QUERY)
    public boolean isAtHandoff() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.HANDOFF;
    }

    @Command(level=1, description="Return true if the trucks are at ONLINE position", type=Command.CommandType.QUERY)
    public boolean isOnline() {
        return this.getTrucksLocation() == FcsEnumerations.AutoChangerTrucksLocation.ONLINE;
    }

    public void updateTrucksLocationWithSensors() {
        block4: {
            this.lock.lock();
            this.updatingTrucksLocation = false;
            try {
                this.railsSensorsDIO.updateValue();
                String dioHexaValue = this.railsSensorsDIO.getHexaValue();
                FCSLOG.debug((Object)(this.railsSensorsDIO.getName() + " HEXA VALUE=" + dioHexaValue));
                this.truckXminus.updateLocation(dioHexaValue);
                this.truckXplus.updateLocation(dioHexaValue);
                if (this.truckXminus.getTruckLocation() == this.truckXplus.getTruckLocation()) {
                    this.trucksLocation = this.truckXminus.getTruckLocation();
                    break block4;
                }
                String msg = this.getName() + "Trucks are not at the same location";
                FCSLOG.error((Object)msg);
                throw new FcsHardwareException(msg);
            }
            finally {
                this.updatingTrucksLocation = false;
                this.trucksLocationUpdated.signal();
                this.lock.unlock();
                this.publishDataAndNotifyObservers();
            }
        }
    }

    public void grabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void ungrabFilterAtHandoff(Filter aFilter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(level=1, description="Open the 2 latches when the autochanger trucks are at HANDOFF position", type=Command.CommandType.ACTION, alias="openLatchesHO")
    public void openLatchesAtHandoff() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Command(level=1, description="Close the 2 latches when the autochanger trucks are at HANDOFF position", type=Command.CommandType.ACTION, alias="closeLatchesHO")
    public void closeLatchesAtHandoff() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

